/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersResponse extends MqResponse implements
        ToCopyableBuilder<ListUsersResponse.Builder, ListUsersResponse> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsersResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListUsersResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField
            .<List<UserSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListUsersResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, USERS_FIELD));

    private final String brokerId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<UserSummary> users;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.users = builder.users;
    }

    /**
     * Required. The unique ID that Amazon MQ generates for the broker.
     * 
     * @return Required. The unique ID that Amazon MQ generates for the broker.
     */
    public String brokerId() {
        return brokerId;
    }

    /**
     * Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be
     * an integer from 5 to 100.
     * 
     * @return Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value
     *         must be an integer from 5 to 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Users property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * Required. The list of all ActiveMQ usernames for the specified broker.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Required. The list of all ActiveMQ usernames for the specified broker.
     */
    public List<UserSummary> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(users());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse) obj;
        return Objects.equals(brokerId(), other.brokerId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUsersResponse").add("BrokerId", brokerId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Users", users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUsersResponse> {
        /**
         * Required. The unique ID that Amazon MQ generates for the broker.
         * 
         * @param brokerId
         *        Required. The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must
         * be an integer from 5 to 100.
         * 
         * @param maxResults
         *        Required. The maximum number of ActiveMQ users that can be returned per page (20 by default). This
         *        value must be an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Required. The list of all ActiveMQ usernames for the specified broker.
         * 
         * @param users
         *        Required. The list of all ActiveMQ usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserSummary> users);

        /**
         * Required. The list of all ActiveMQ usernames for the specified broker.
         * 
         * @param users
         *        Required. The list of all ActiveMQ usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserSummary... users);

        /**
         * Required. The list of all ActiveMQ usernames for the specified broker. This is a convenience that creates an
         * instance of the {@link List<UserSummary>.Builder} avoiding the need to create one manually via {@link List
         * <UserSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<UserSummary>)}.
         * 
         * @param users
         *        a consumer that will call methods on {@link List<UserSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(List<UserSummary>)
         */
        Builder users(Consumer<UserSummary.Builder>... users);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String brokerId;

        private Integer maxResults;

        private String nextToken;

        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            brokerId(model.brokerId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            users(model.users);
        }

        public final String getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<UserSummary.Builder> getUsers() {
            return users != null ? users.stream().map(UserSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ___listOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder>... users) {
            users(Stream.of(users).map(c -> UserSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ___listOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
