/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerInstanceOptionsResponse extends MqResponse implements
        ToCopyableBuilder<DescribeBrokerInstanceOptionsResponse.Builder, DescribeBrokerInstanceOptionsResponse> {
    private static final SdkField<List<BrokerInstanceOption>> BROKER_INSTANCE_OPTIONS_FIELD = SdkField
            .<List<BrokerInstanceOption>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerInstanceOptionsResponse::brokerInstanceOptions))
            .setter(setter(Builder::brokerInstanceOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstanceOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerInstanceOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerInstanceOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeBrokerInstanceOptionsResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerInstanceOptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_INSTANCE_OPTIONS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BrokerInstanceOption> brokerInstanceOptions;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeBrokerInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.brokerInstanceOptions = builder.brokerInstanceOptions;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BrokerInstanceOptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBrokerInstanceOptions() {
        return brokerInstanceOptions != null && !(brokerInstanceOptions instanceof SdkAutoConstructList);
    }

    /**
     * List of available broker instance options.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerInstanceOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of available broker instance options.
     */
    public List<BrokerInstanceOption> brokerInstanceOptions() {
        return brokerInstanceOptions;
    }

    /**
     * Required. The maximum number of instance options that can be returned per page (20 by default). This value must
     * be an integer from 5 to 100.
     * 
     * @return Required. The maximum number of instance options that can be returned per page (20 by default). This
     *         value must be an integer from 5 to 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerInstanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerInstanceOptionsResponse)) {
            return false;
        }
        DescribeBrokerInstanceOptionsResponse other = (DescribeBrokerInstanceOptionsResponse) obj;
        return Objects.equals(brokerInstanceOptions(), other.brokerInstanceOptions())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBrokerInstanceOptionsResponse").add("BrokerInstanceOptions", brokerInstanceOptions())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerInstanceOptions":
            return Optional.ofNullable(clazz.cast(brokerInstanceOptions()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerInstanceOptionsResponse, T> g) {
        return obj -> g.apply((DescribeBrokerInstanceOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerInstanceOptionsResponse> {
        /**
         * List of available broker instance options.
         * 
         * @param brokerInstanceOptions
         *        List of available broker instance options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstanceOptions(Collection<BrokerInstanceOption> brokerInstanceOptions);

        /**
         * List of available broker instance options.
         * 
         * @param brokerInstanceOptions
         *        List of available broker instance options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstanceOptions(BrokerInstanceOption... brokerInstanceOptions);

        /**
         * List of available broker instance options. This is a convenience that creates an instance of the {@link List
         * <BrokerInstanceOption>.Builder} avoiding the need to create one manually via {@link List
         * <BrokerInstanceOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BrokerInstanceOption>.Builder#build()} is called immediately
         * and its result is passed to {@link #brokerInstanceOptions(List<BrokerInstanceOption>)}.
         * 
         * @param brokerInstanceOptions
         *        a consumer that will call methods on {@link List<BrokerInstanceOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerInstanceOptions(List<BrokerInstanceOption>)
         */
        Builder brokerInstanceOptions(Consumer<BrokerInstanceOption.Builder>... brokerInstanceOptions);

        /**
         * Required. The maximum number of instance options that can be returned per page (20 by default). This value
         * must be an integer from 5 to 100.
         * 
         * @param maxResults
         *        Required. The maximum number of instance options that can be returned per page (20 by default). This
         *        value must be an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private List<BrokerInstanceOption> brokerInstanceOptions = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerInstanceOptionsResponse model) {
            super(model);
            brokerInstanceOptions(model.brokerInstanceOptions);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<BrokerInstanceOption.Builder> getBrokerInstanceOptions() {
            return brokerInstanceOptions != null ? brokerInstanceOptions.stream().map(BrokerInstanceOption::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerInstanceOptions(Collection<BrokerInstanceOption> brokerInstanceOptions) {
            this.brokerInstanceOptions = ___listOfBrokerInstanceOptionCopier.copy(brokerInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstanceOptions(BrokerInstanceOption... brokerInstanceOptions) {
            brokerInstanceOptions(Arrays.asList(brokerInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstanceOptions(Consumer<BrokerInstanceOption.Builder>... brokerInstanceOptions) {
            brokerInstanceOptions(Stream.of(brokerInstanceOptions)
                    .map(c -> BrokerInstanceOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerInstanceOptions(Collection<BrokerInstanceOption.BuilderImpl> brokerInstanceOptions) {
            this.brokerInstanceOptions = ___listOfBrokerInstanceOptionCopier.copyFromBuilder(brokerInstanceOptions);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBrokerInstanceOptionsResponse build() {
            return new DescribeBrokerInstanceOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
