/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRevisionRequest extends MqRequest implements
        ToCopyableBuilder<DescribeConfigurationRevisionRequest.Builder, DescribeConfigurationRevisionRequest> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationRevisionRequest::configurationId)).setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuration-id").build()).build();

    private static final SdkField<String> CONFIGURATION_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeConfigurationRevisionRequest::configurationRevision))
            .setter(setter(Builder::configurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuration-revision").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            CONFIGURATION_REVISION_FIELD));

    private final String configurationId;

    private final String configurationRevision;

    private DescribeConfigurationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.configurationRevision = builder.configurationRevision;
    }

    /**
     * The unique ID that Amazon MQ generates for the configuration.
     * 
     * @return The unique ID that Amazon MQ generates for the configuration.
     */
    public String configurationId() {
        return configurationId;
    }

    /**
     * The revision of the configuration.
     * 
     * @return The revision of the configuration.
     */
    public String configurationRevision() {
        return configurationRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationRevision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionRequest)) {
            return false;
        }
        DescribeConfigurationRevisionRequest other = (DescribeConfigurationRevisionRequest) obj;
        return Objects.equals(configurationId(), other.configurationId())
                && Objects.equals(configurationRevision(), other.configurationRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationRevisionRequest").add("ConfigurationId", configurationId())
                .add("ConfigurationRevision", configurationRevision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "ConfigurationRevision":
            return Optional.ofNullable(clazz.cast(configurationRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRevisionRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationRevisionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConfigurationRevisionRequest> {
        /**
         * The unique ID that Amazon MQ generates for the configuration.
         * 
         * @param configurationId
         *        The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * The revision of the configuration.
         * 
         * @param configurationRevision
         *        The revision of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRevision(String configurationRevision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MqRequest.BuilderImpl implements Builder {
        private String configurationId;

        private String configurationRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionRequest model) {
            super(model);
            configurationId(model.configurationId);
            configurationRevision(model.configurationRevision);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getConfigurationRevision() {
            return configurationRevision;
        }

        @Override
        public final Builder configurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
            return this;
        }

        public final void setConfigurationRevision(String configurationRevision) {
            this.configurationRevision = configurationRevision;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRevisionRequest build() {
            return new DescribeConfigurationRevisionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
