/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Types of broker engines.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerEngineType implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerEngineType.Builder, BrokerEngineType> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerEngineType::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<List<EngineVersion>> ENGINE_VERSIONS_FIELD = SdkField
            .<List<EngineVersion>> builder(MarshallingType.LIST)
            .getter(getter(BrokerEngineType::engineVersions))
            .setter(setter(Builder::engineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD,
            ENGINE_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineType;

    private final List<EngineVersion> engineVersions;

    private BrokerEngineType(BuilderImpl builder) {
        this.engineType = builder.engineType;
        this.engineVersions = builder.engineVersions;
    }

    /**
     * The type of broker engine.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of broker engine.
     * @see EngineType
     */
    public EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * The type of broker engine.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of broker engine.
     * @see EngineType
     */
    public String engineTypeAsString() {
        return engineType;
    }

    /**
     * Returns true if the EngineVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEngineVersions() {
        return engineVersions != null && !(engineVersions instanceof SdkAutoConstructList);
    }

    /**
     * The list of engine versions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEngineVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of engine versions.
     */
    public List<EngineVersion> engineVersions() {
        return engineVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEngineType)) {
            return false;
        }
        BrokerEngineType other = (BrokerEngineType) obj;
        return Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersions(), other.engineVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BrokerEngineType").add("EngineType", engineTypeAsString())
                .add("EngineVersions", engineVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersions":
            return Optional.ofNullable(clazz.cast(engineVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerEngineType, T> g) {
        return obj -> g.apply((BrokerEngineType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerEngineType> {
        /**
         * The type of broker engine.
         * 
         * @param engineType
         *        The type of broker engine.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * The type of broker engine.
         * 
         * @param engineType
         *        The type of broker engine.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * The list of engine versions.
         * 
         * @param engineVersions
         *        The list of engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(Collection<EngineVersion> engineVersions);

        /**
         * The list of engine versions.
         * 
         * @param engineVersions
         *        The list of engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(EngineVersion... engineVersions);

        /**
         * The list of engine versions. This is a convenience that creates an instance of the {@link List
         * <EngineVersion>.Builder} avoiding the need to create one manually via {@link List<EngineVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #engineVersions(List<EngineVersion>)}.
         * 
         * @param engineVersions
         *        a consumer that will call methods on {@link List<EngineVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersions(List<EngineVersion>)
         */
        Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions);
    }

    static final class BuilderImpl implements Builder {
        private String engineType;

        private List<EngineVersion> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerEngineType model) {
            engineType(model.engineType);
            engineVersions(model.engineVersions);
        }

        public final String getEngineTypeAsString() {
            return engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final Collection<EngineVersion.Builder> getEngineVersions() {
            return engineVersions != null ? engineVersions.stream().map(EngineVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersion> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersion... engineVersions) {
            engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions) {
            engineVersions(Stream.of(engineVersions).map(c -> EngineVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEngineVersions(Collection<EngineVersion.BuilderImpl> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copyFromBuilder(engineVersions);
        }

        @Override
        public BrokerEngineType build() {
            return new BrokerEngineType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
