/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mq.model.MQRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConfigurationRequest
extends MQRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationRequest> {
    private final String configurationId;
    private final String data;
    private final String description;

    private UpdateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.data = builder.data;
        this.description = builder.description;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String data() {
        return this.data;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationRequest)) {
            return false;
        }
        UpdateConfigurationRequest other = (UpdateConfigurationRequest)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationRequest").add("ConfigurationId", (Object)this.configurationId()).add("Data", (Object)this.data()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationId": {
                return Optional.of(clazz.cast(this.configurationId()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQRequest.BuilderImpl
    implements Builder {
        private String configurationId;
        private String data;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationRequest model) {
            this.configurationId(model.configurationId);
            this.data(model.data);
            this.description(model.description);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationRequest build() {
            return new UpdateConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends MQRequest.Builder,
    CopyableBuilder<Builder, UpdateConfigurationRequest> {
        public Builder configurationId(String var1);

        public Builder data(String var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

