/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.mq.model.ListOf__stringCopier;
import software.amazon.awssdk.services.mq.model.MQResponse;
import software.amazon.awssdk.services.mq.model.UserPendingChanges;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUserResponse
extends MQResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private final String brokerId;
    private final Boolean consoleAccess;
    private final List<String> groups;
    private final UserPendingChanges pending;
    private final String username;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.pending = builder.pending;
        this.username = builder.username;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public Boolean consoleAccess() {
        return this.consoleAccess;
    }

    public List<String> groups() {
        return this.groups;
    }

    public UserPendingChanges pending() {
        return this.pending;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.consoleAccess(), other.consoleAccess()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.pending(), other.pending()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("BrokerId", (Object)this.brokerId()).add("ConsoleAccess", (Object)this.consoleAccess()).add("Groups", this.groups()).add("Pending", (Object)this.pending()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.of(clazz.cast(this.brokerId()));
            }
            case "ConsoleAccess": {
                return Optional.of(clazz.cast(this.consoleAccess()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "Pending": {
                return Optional.of(clazz.cast(this.pending()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQResponse.BuilderImpl
    implements Builder {
        private String brokerId;
        private Boolean consoleAccess;
        private List<String> groups;
        private UserPendingChanges pending;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            this.brokerId(model.brokerId);
            this.consoleAccess(model.consoleAccess);
            this.groups(model.groups);
            this.pending(model.pending);
            this.username(model.username);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Boolean getConsoleAccess() {
            return this.consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ListOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ListOf__stringCopier.copy(groups);
        }

        public final UserPendingChanges.Builder getPending() {
            return this.pending != null ? this.pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(UserPendingChanges pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(UserPendingChanges.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }
    }

    public static interface Builder
    extends MQResponse.Builder,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder brokerId(String var1);

        public Builder consoleAccess(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder pending(UserPendingChanges var1);

        default public Builder pending(Consumer<UserPendingChanges.Builder> pending) {
            return this.pending((UserPendingChanges)((UserPendingChanges.Builder)UserPendingChanges.builder().apply(pending)).build());
        }

        public Builder username(String var1);
    }
}

