/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.Configurations;

@SdkInternalApi
public class ConfigurationsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CURRENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("current").build();
    private static final MarshallingInfo<List> HISTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("history").build();
    private static final MarshallingInfo<StructuredPojo> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pending").build();
    private static final ConfigurationsMarshaller INSTANCE = new ConfigurationsMarshaller();

    public static ConfigurationsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Configurations configurations, ProtocolMarshaller protocolMarshaller) {
        if (configurations == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configurations.current(), CURRENT_BINDING);
            protocolMarshaller.marshall(configurations.history(), HISTORY_BINDING);
            protocolMarshaller.marshall((Object)configurations.pending(), PENDING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

