/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.mq.model.BrokerInstance;
import software.amazon.awssdk.services.mq.model.BrokerState;
import software.amazon.awssdk.services.mq.model.Configurations;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.ListOfBrokerInstanceCopier;
import software.amazon.awssdk.services.mq.model.ListOfUserSummaryCopier;
import software.amazon.awssdk.services.mq.model.ListOf__stringCopier;
import software.amazon.awssdk.services.mq.model.MQResponse;
import software.amazon.awssdk.services.mq.model.UserSummary;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBrokerResponse
extends MQResponse
implements ToCopyableBuilder<Builder, DescribeBrokerResponse> {
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerArn;
    private final String brokerId;
    private final List<BrokerInstance> brokerInstances;
    private final String brokerName;
    private final String brokerState;
    private final Configurations configurations;
    private final String deploymentMode;
    private final String engineType;
    private final String engineVersion;
    private final String hostInstanceType;
    private final WeeklyStartTime maintenanceWindowStartTime;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroups;
    private final List<String> subnetIds;
    private final List<UserSummary> users;

    private DescribeBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerInstances = builder.brokerInstances;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.configurations = builder.configurations;
        this.deploymentMode = builder.deploymentMode;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.subnetIds = builder.subnetIds;
        this.users = builder.users;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String brokerArn() {
        return this.brokerArn;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public List<BrokerInstance> brokerInstances() {
        return this.brokerInstances;
    }

    public String brokerName() {
        return this.brokerName;
    }

    public BrokerState brokerState() {
        return BrokerState.fromValue(this.brokerState);
    }

    public String brokerStateString() {
        return this.brokerState;
    }

    public Configurations configurations() {
        return this.configurations;
    }

    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public String deploymentModeString() {
        return this.deploymentMode;
    }

    public EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public String engineTypeString() {
        return this.engineType;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public WeeklyStartTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<UserSummary> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerStateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerResponse)) {
            return false;
        }
        DescribeBrokerResponse other = (DescribeBrokerResponse)((Object)obj);
        return Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerArn(), other.brokerArn()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.brokerInstances(), other.brokerInstances()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.brokerStateString(), other.brokerStateString()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.deploymentModeString(), other.deploymentModeString()) && Objects.equals(this.engineTypeString(), other.engineTypeString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBrokerResponse").add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerArn", (Object)this.brokerArn()).add("BrokerId", (Object)this.brokerId()).add("BrokerInstances", this.brokerInstances()).add("BrokerName", (Object)this.brokerName()).add("BrokerState", (Object)this.brokerStateString()).add("Configurations", (Object)this.configurations()).add("DeploymentMode", (Object)this.deploymentModeString()).add("EngineType", (Object)this.engineTypeString()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroups", this.securityGroups()).add("SubnetIds", this.subnetIds()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerArn": {
                return Optional.of(clazz.cast(this.brokerArn()));
            }
            case "BrokerId": {
                return Optional.of(clazz.cast(this.brokerId()));
            }
            case "BrokerInstances": {
                return Optional.of(clazz.cast(this.brokerInstances()));
            }
            case "BrokerName": {
                return Optional.of(clazz.cast(this.brokerName()));
            }
            case "BrokerState": {
                return Optional.of(clazz.cast(this.brokerStateString()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "DeploymentMode": {
                return Optional.of(clazz.cast(this.deploymentModeString()));
            }
            case "EngineType": {
                return Optional.of(clazz.cast(this.engineTypeString()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.of(clazz.cast(this.hostInstanceType()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.of(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQResponse.BuilderImpl
    implements Builder {
        private Boolean autoMinorVersionUpgrade;
        private String brokerArn;
        private String brokerId;
        private List<BrokerInstance> brokerInstances;
        private String brokerName;
        private String brokerState;
        private Configurations configurations;
        private String deploymentMode;
        private String engineType;
        private String engineVersion;
        private String hostInstanceType;
        private WeeklyStartTime maintenanceWindowStartTime;
        private Boolean publiclyAccessible;
        private List<String> securityGroups;
        private List<String> subnetIds;
        private List<UserSummary> users;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerResponse model) {
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerArn(model.brokerArn);
            this.brokerId(model.brokerId);
            this.brokerInstances(model.brokerInstances);
            this.brokerName(model.brokerName);
            this.brokerState(model.brokerState);
            this.configurations(model.configurations);
            this.deploymentMode(model.deploymentMode);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroups(model.securityGroups);
            this.subnetIds(model.subnetIds);
            this.users(model.users);
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerArn() {
            return this.brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Collection<BrokerInstance.Builder> getBrokerInstances() {
            return this.brokerInstances != null ? (Collection)this.brokerInstances.stream().map(BrokerInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerInstances(Collection<BrokerInstance> brokerInstances) {
            this.brokerInstances = ListOfBrokerInstanceCopier.copy(brokerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(BrokerInstance ... brokerInstances) {
            this.brokerInstances(Arrays.asList(brokerInstances));
            return this;
        }

        public final void setBrokerInstances(Collection<BrokerInstance.BuilderImpl> brokerInstances) {
            this.brokerInstances = ListOfBrokerInstanceCopier.copyFromBuilder(brokerInstances);
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final String getBrokerState() {
            return this.brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState.toString());
            return this;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        public final Configurations.Builder getConfigurations() {
            return this.configurations != null ? this.configurations.toBuilder() : null;
        }

        @Override
        public final Builder configurations(Configurations configurations) {
            this.configurations = configurations;
            return this;
        }

        public final void setConfigurations(Configurations.BuilderImpl configurations) {
            this.configurations = configurations != null ? configurations.build() : null;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ListOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ListOf__stringCopier.copy(subnetIds);
        }

        public final Collection<UserSummary.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(UserSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ListOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ListOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public DescribeBrokerResponse build() {
            return new DescribeBrokerResponse(this);
        }
    }

    public static interface Builder
    extends MQResponse.Builder,
    CopyableBuilder<Builder, DescribeBrokerResponse> {
        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerArn(String var1);

        public Builder brokerId(String var1);

        public Builder brokerInstances(Collection<BrokerInstance> var1);

        public Builder brokerInstances(BrokerInstance ... var1);

        public Builder brokerName(String var1);

        public Builder brokerState(String var1);

        public Builder brokerState(BrokerState var1);

        public Builder configurations(Configurations var1);

        default public Builder configurations(Consumer<Configurations.Builder> configurations) {
            return this.configurations((Configurations)((Configurations.Builder)Configurations.builder().apply(configurations)).build());
        }

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder maintenanceWindowStartTime(WeeklyStartTime var1);

        default public Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((WeeklyStartTime)((WeeklyStartTime.Builder)WeeklyStartTime.builder().apply(maintenanceWindowStartTime)).build());
        }

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder users(Collection<UserSummary> var1);

        public Builder users(UserSummary ... var1);
    }
}

