/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.Logs;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerRequest
extends MqRequest
implements ToCopyableBuilder<Builder, UpdateBrokerRequest> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::brokerId)).setter(UpdateBrokerRequest.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("broker-id").build()}).build();
    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::configuration)).setter(UpdateBrokerRequest.setter(Builder::configuration)).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Logs> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateBrokerRequest.getter(UpdateBrokerRequest::logs)).setter(UpdateBrokerRequest.setter(Builder::logs)).constructor(Logs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD, CONFIGURATION_FIELD, LOGS_FIELD));
    private final String brokerId;
    private final ConfigurationId configuration;
    private final Logs logs;

    private UpdateBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.logs = builder.logs;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public ConfigurationId configuration() {
        return this.configuration;
    }

    public Logs logs() {
        return this.logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerRequest)) {
            return false;
        }
        UpdateBrokerRequest other = (UpdateBrokerRequest)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.logs(), other.logs());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBrokerRequest").add("BrokerId", (Object)this.brokerId()).add("Configuration", (Object)this.configuration()).add("Logs", (Object)this.logs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerRequest, T> g) {
        return obj -> g.apply((UpdateBrokerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqRequest.BuilderImpl
    implements Builder {
        private String brokerId;
        private ConfigurationId configuration;
        private Logs logs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerRequest model) {
            super(model);
            this.brokerId(model.brokerId);
            this.configuration(model.configuration);
            this.logs(model.logs);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Logs.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrokerRequest build() {
            return new UpdateBrokerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerRequest> {
        public Builder brokerId(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(configuration)).build());
        }

        public Builder logs(Logs var1);

        default public Builder logs(Consumer<Logs.Builder> logs) {
            return this.logs((Logs)((Logs.Builder)Logs.builder().applyMutation(logs)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

