/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.LogsSummary;
import software.amazon.awssdk.services.mq.transform.PendingLogsUnmarshaller;

public class LogsSummaryUnmarshaller
implements Unmarshaller<LogsSummary, JsonUnmarshallerContext> {
    private static final LogsSummaryUnmarshaller INSTANCE = new LogsSummaryUnmarshaller();

    public LogsSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        LogsSummary.Builder logsSummaryBuilder = LogsSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audit", targetDepth)) {
                    context.nextToken();
                    logsSummaryBuilder.audit((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("auditLogGroup", targetDepth)) {
                    context.nextToken();
                    logsSummaryBuilder.auditLogGroup((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("general", targetDepth)) {
                    context.nextToken();
                    logsSummaryBuilder.general((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("generalLogGroup", targetDepth)) {
                    context.nextToken();
                    logsSummaryBuilder.generalLogGroup((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("pending", targetDepth)) {
                    context.nextToken();
                    logsSummaryBuilder.pending(PendingLogsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LogsSummary)logsSummaryBuilder.build();
    }

    public static LogsSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

