/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.LogsSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogsSummaryMarshaller {
    private static final MarshallingInfo<Boolean> AUDIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audit").isBinary(false).build();
    private static final MarshallingInfo<String> AUDITLOGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("auditLogGroup").isBinary(false).build();
    private static final MarshallingInfo<Boolean> GENERAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("general").isBinary(false).build();
    private static final MarshallingInfo<String> GENERALLOGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("generalLogGroup").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pending").isBinary(false).build();
    private static final LogsSummaryMarshaller INSTANCE = new LogsSummaryMarshaller();

    private LogsSummaryMarshaller() {
    }

    public static LogsSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogsSummary logsSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logsSummary, (String)"logsSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logsSummary.audit(), AUDIT_BINDING);
            protocolMarshaller.marshall((Object)logsSummary.auditLogGroup(), AUDITLOGGROUP_BINDING);
            protocolMarshaller.marshall((Object)logsSummary.general(), GENERAL_BINDING);
            protocolMarshaller.marshall((Object)logsSummary.generalLogGroup(), GENERALLOGGROUP_BINDING);
            protocolMarshaller.marshall((Object)logsSummary.pending(), PENDING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

