/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.Configuration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineType").isBinary(false).build();
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineVersion").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LATESTREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestRevision").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final ConfigurationMarshaller INSTANCE = new ConfigurationMarshaller();

    private ConfigurationMarshaller() {
    }

    public static ConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Configuration configuration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configuration, (String)"configuration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configuration.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configuration.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)configuration.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)configuration.engineTypeAsString(), ENGINETYPE_BINDING);
            protocolMarshaller.marshall((Object)configuration.engineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)configuration.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)configuration.latestRevision(), LATESTREVISION_BINDING);
            protocolMarshaller.marshall((Object)configuration.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

