/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.BrokerSummary;

public class BrokerSummaryUnmarshaller
implements Unmarshaller<BrokerSummary, JsonUnmarshallerContext> {
    private static final BrokerSummaryUnmarshaller INSTANCE = new BrokerSummaryUnmarshaller();

    public BrokerSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        BrokerSummary.Builder brokerSummaryBuilder = BrokerSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("brokerArn", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.brokerArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("brokerId", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.brokerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("brokerName", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.brokerName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("brokerState", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.brokerState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("created", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.created((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("deploymentMode", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.deploymentMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hostInstanceType", targetDepth)) {
                    context.nextToken();
                    brokerSummaryBuilder.hostInstanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BrokerSummary)brokerSummaryBuilder.build();
    }

    public static BrokerSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

