/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.BrokerSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BrokerSummaryMarshaller {
    private static final MarshallingInfo<String> BROKERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerArn").isBinary(false).build();
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerId").isBinary(false).build();
    private static final MarshallingInfo<String> BROKERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerName").isBinary(false).build();
    private static final MarshallingInfo<String> BROKERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("brokerState").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentMode").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostInstanceType").isBinary(false).build();
    private static final BrokerSummaryMarshaller INSTANCE = new BrokerSummaryMarshaller();

    private BrokerSummaryMarshaller() {
    }

    public static BrokerSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BrokerSummary brokerSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)brokerSummary, (String)"brokerSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)brokerSummary.brokerArn(), BROKERARN_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerName(), BROKERNAME_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.brokerStateAsString(), BROKERSTATE_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.deploymentModeAsString(), DEPLOYMENTMODE_BINDING);
            protocolMarshaller.marshall((Object)brokerSummary.hostInstanceType(), HOSTINSTANCETYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

