/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.model.BrokerInstance;

public class BrokerInstanceUnmarshaller
implements Unmarshaller<BrokerInstance, JsonUnmarshallerContext> {
    private static final BrokerInstanceUnmarshaller INSTANCE = new BrokerInstanceUnmarshaller();

    public BrokerInstance unmarshall(JsonUnmarshallerContext context) throws Exception {
        BrokerInstance.Builder brokerInstanceBuilder = BrokerInstance.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("consoleURL", targetDepth)) {
                    context.nextToken();
                    brokerInstanceBuilder.consoleURL((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("endpoints", targetDepth)) {
                    context.nextToken();
                    brokerInstanceBuilder.endpoints(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ipAddress", targetDepth)) {
                    context.nextToken();
                    brokerInstanceBuilder.ipAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BrokerInstance)brokerInstanceBuilder.build();
    }

    public static BrokerInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

