/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.ChangeType;
import software.amazon.awssdk.services.mq.transform.UserSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, UserSummary> {
    private final String pendingChange;
    private final String username;

    private UserSummary(BuilderImpl builder) {
        this.pendingChange = builder.pendingChange;
        this.username = builder.username;
    }

    public ChangeType pendingChange() {
        return ChangeType.fromValue(this.pendingChange);
    }

    public String pendingChangeAsString() {
        return this.pendingChange;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingChangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary)obj;
        return Objects.equals(this.pendingChangeAsString(), other.pendingChangeAsString()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"UserSummary").add("PendingChange", (Object)this.pendingChangeAsString()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingChange": {
                return Optional.ofNullable(clazz.cast(this.pendingChangeAsString()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pendingChange;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSummary model) {
            this.pendingChange(model.pendingChange);
            this.username(model.username);
        }

        public final String getPendingChange() {
            return this.pendingChange;
        }

        @Override
        public final Builder pendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
            return this;
        }

        @Override
        public final Builder pendingChange(ChangeType pendingChange) {
            this.pendingChange(pendingChange.toString());
            return this;
        }

        public final void setPendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public UserSummary build() {
            return new UserSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserSummary> {
        public Builder pendingChange(String var1);

        public Builder pendingChange(ChangeType var1);

        public Builder username(String var1);
    }
}

