/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.PendingLogs;
import software.amazon.awssdk.services.mq.transform.LogsSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogsSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, LogsSummary> {
    private final Boolean audit;
    private final String auditLogGroup;
    private final Boolean general;
    private final String generalLogGroup;
    private final PendingLogs pending;

    private LogsSummary(BuilderImpl builder) {
        this.audit = builder.audit;
        this.auditLogGroup = builder.auditLogGroup;
        this.general = builder.general;
        this.generalLogGroup = builder.generalLogGroup;
        this.pending = builder.pending;
    }

    public Boolean audit() {
        return this.audit;
    }

    public String auditLogGroup() {
        return this.auditLogGroup;
    }

    public Boolean general() {
        return this.general;
    }

    public String generalLogGroup() {
        return this.generalLogGroup;
    }

    public PendingLogs pending() {
        return this.pending;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audit());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.general());
        hashCode = 31 * hashCode + Objects.hashCode(this.generalLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsSummary)) {
            return false;
        }
        LogsSummary other = (LogsSummary)obj;
        return Objects.equals(this.audit(), other.audit()) && Objects.equals(this.auditLogGroup(), other.auditLogGroup()) && Objects.equals(this.general(), other.general()) && Objects.equals(this.generalLogGroup(), other.generalLogGroup()) && Objects.equals(this.pending(), other.pending());
    }

    public String toString() {
        return ToString.builder((String)"LogsSummary").add("Audit", (Object)this.audit()).add("AuditLogGroup", (Object)this.auditLogGroup()).add("General", (Object)this.general()).add("GeneralLogGroup", (Object)this.generalLogGroup()).add("Pending", (Object)this.pending()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audit": {
                return Optional.ofNullable(clazz.cast(this.audit()));
            }
            case "AuditLogGroup": {
                return Optional.ofNullable(clazz.cast(this.auditLogGroup()));
            }
            case "General": {
                return Optional.ofNullable(clazz.cast(this.general()));
            }
            case "GeneralLogGroup": {
                return Optional.ofNullable(clazz.cast(this.generalLogGroup()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogsSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean audit;
        private String auditLogGroup;
        private Boolean general;
        private String generalLogGroup;
        private PendingLogs pending;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsSummary model) {
            this.audit(model.audit);
            this.auditLogGroup(model.auditLogGroup);
            this.general(model.general);
            this.generalLogGroup(model.generalLogGroup);
            this.pending(model.pending);
        }

        public final Boolean getAudit() {
            return this.audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        public final String getAuditLogGroup() {
            return this.auditLogGroup;
        }

        @Override
        public final Builder auditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
            return this;
        }

        public final void setAuditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
        }

        public final Boolean getGeneral() {
            return this.general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        public final String getGeneralLogGroup() {
            return this.generalLogGroup;
        }

        @Override
        public final Builder generalLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
            return this;
        }

        public final void setGeneralLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
        }

        public final PendingLogs.Builder getPending() {
            return this.pending != null ? this.pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(PendingLogs pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(PendingLogs.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        public LogsSummary build() {
            return new LogsSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogsSummary> {
        public Builder audit(Boolean var1);

        public Builder auditLogGroup(String var1);

        public Builder general(Boolean var1);

        public Builder generalLogGroup(String var1);

        public Builder pending(PendingLogs var1);

        default public Builder pending(Consumer<PendingLogs.Builder> pending) {
            return this.pending((PendingLogs)((PendingLogs.Builder)PendingLogs.builder().applyMutation(pending)).build());
        }
    }
}

