/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.BadRequestException;
import software.amazon.awssdk.services.mq.model.ConflictException;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.services.mq.model.CreateUserResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteUserRequest;
import software.amazon.awssdk.services.mq.model.DeleteUserResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.mq.model.DescribeUserRequest;
import software.amazon.awssdk.services.mq.model.DescribeUserResponse;
import software.amazon.awssdk.services.mq.model.ForbiddenException;
import software.amazon.awssdk.services.mq.model.InternalServerErrorException;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.mq.model.ListUsersRequest;
import software.amazon.awssdk.services.mq.model.ListUsersResponse;
import software.amazon.awssdk.services.mq.model.MqException;
import software.amazon.awssdk.services.mq.model.NotFoundException;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UnauthorizedException;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.services.mq.model.UpdateUserResponse;
import software.amazon.awssdk.services.mq.transform.CreateBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateBrokerResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.CreateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateUserResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteBrokerResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeBrokerResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationRevisionRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeUserResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.ListBrokersRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListBrokersResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationRevisionsResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationsResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListUsersResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.RebootBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.RebootBrokerResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateBrokerResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateUserResponseUnmarshaller;

@SdkInternalApi
final class DefaultMqClient
implements MqClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMqClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "mq";
    }

    @Override
    public CreateBrokerResponse createBroker(CreateBrokerRequest createBrokerRequest) throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBrokerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBrokerRequest).withMarshaller((Marshaller)new CreateBrokerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateConfigurationResponse createConfiguration(CreateConfigurationRequest createConfigurationRequest) throws BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationRequest).withMarshaller((Marshaller)new CreateConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUserResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMarshaller((Marshaller)new CreateUserRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteBrokerResponse deleteBroker(DeleteBrokerRequest deleteBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBrokerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBrokerRequest).withMarshaller((Marshaller)new DeleteBrokerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeBrokerResponse describeBroker(DescribeBrokerRequest describeBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBrokerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBrokerRequest).withMarshaller((Marshaller)new DescribeBrokerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationResponse describeConfiguration(DescribeConfigurationRequest describeConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRequest).withMarshaller((Marshaller)new DescribeConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeConfigurationRevisionResponse describeConfigurationRevision(DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeConfigurationRevisionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeConfigurationRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRevisionRequest).withMarshaller((Marshaller)new DescribeConfigurationRevisionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMarshaller((Marshaller)new DescribeUserRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListBrokersResponse listBrokers(ListBrokersRequest listBrokersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBrokersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListBrokersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBrokersRequest).withMarshaller((Marshaller)new ListBrokersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListConfigurationRevisionsResponse listConfigurationRevisions(ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConfigurationRevisionsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListConfigurationRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationRevisionsRequest).withMarshaller((Marshaller)new ListConfigurationRevisionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListConfigurationsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationsRequest).withMarshaller((Marshaller)new ListConfigurationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsersResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMarshaller((Marshaller)new ListUsersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootBrokerResponse rebootBroker(RebootBrokerRequest rebootBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RebootBrokerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RebootBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootBrokerRequest).withMarshaller((Marshaller)new RebootBrokerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateBrokerResponse updateBroker(UpdateBrokerRequest updateBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBrokerResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBrokerRequest).withMarshaller((Marshaller)new UpdateBrokerRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationRequest).withMarshaller((Marshaller)new UpdateConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest).withMarshaller((Marshaller)new UpdateUserRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(MqException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

