/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("broker-id").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CONSOLEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("consoleAccess").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groups").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("username").isBinary(false).build();
    private static final CreateUserRequestModelMarshaller INSTANCE = new CreateUserRequestModelMarshaller();

    private CreateUserRequestModelMarshaller() {
    }

    public static CreateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserRequest createUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createUserRequest), (String)"createUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createUserRequest.brokerId(), BROKERID_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.consoleAccess(), CONSOLEACCESS_BINDING);
            protocolMarshaller.marshall(createUserRequest.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)createUserRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

