/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.BrokerInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BrokerInstanceMarshaller {
    private static final MarshallingInfo<String> CONSOLEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("consoleURL").isBinary(false).build();
    private static final MarshallingInfo<List> ENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoints").isBinary(false).build();
    private static final BrokerInstanceMarshaller INSTANCE = new BrokerInstanceMarshaller();

    private BrokerInstanceMarshaller() {
    }

    public static BrokerInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BrokerInstance brokerInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)brokerInstance, (String)"brokerInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)brokerInstance.consoleURL(), CONSOLEURL_BINDING);
            protocolMarshaller.marshall(brokerInstance.endpoints(), ENDPOINTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

