/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mq.model.SanitizationWarningReason;
import software.amazon.awssdk.services.mq.transform.SanitizationWarningMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SanitizationWarning
implements StructuredPojo,
ToCopyableBuilder<Builder, SanitizationWarning> {
    private final String attributeName;
    private final String elementName;
    private final String reason;

    private SanitizationWarning(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.elementName = builder.elementName;
        this.reason = builder.reason;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String elementName() {
        return this.elementName;
    }

    public SanitizationWarningReason reason() {
        return SanitizationWarningReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.elementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SanitizationWarning)) {
            return false;
        }
        SanitizationWarning other = (SanitizationWarning)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.elementName(), other.elementName()) && Objects.equals(this.reasonAsString(), other.reasonAsString());
    }

    public String toString() {
        return ToString.builder((String)"SanitizationWarning").add("AttributeName", (Object)this.attributeName()).add("ElementName", (Object)this.elementName()).add("Reason", (Object)this.reasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ElementName": {
                return Optional.ofNullable(clazz.cast(this.elementName()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SanitizationWarningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String elementName;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(SanitizationWarning model) {
            this.attributeName(model.attributeName);
            this.elementName(model.elementName);
            this.reason(model.reason);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getElementName() {
            return this.elementName;
        }

        @Override
        public final Builder elementName(String elementName) {
            this.elementName = elementName;
            return this;
        }

        public final void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SanitizationWarningReason reason) {
            this.reason(reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public SanitizationWarning build() {
            return new SanitizationWarning(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SanitizationWarning> {
        public Builder attributeName(String var1);

        public Builder elementName(String var1);

        public Builder reason(String var1);

        public Builder reason(SanitizationWarningReason var1);
    }
}

