/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.Configuration;
import software.amazon.awssdk.services.mq.model.ListOfConfigurationCopier;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationsResponse
extends MqResponse
implements ToCopyableBuilder<Builder, ListConfigurationsResponse> {
    private final List<Configuration> configurations;
    private final Integer maxResults;
    private final String nextToken;

    private ListConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsResponse)) {
            return false;
        }
        ListConfigurationsResponse other = (ListConfigurationsResponse)((Object)obj);
        return Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConfigurationsResponse").add("Configurations", this.configurations()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsResponse model) {
            super(model);
            this.configurations(model.configurations);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ListOfConfigurationCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ListOfConfigurationCopier.copyFromBuilder(configurations);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationsResponse build() {
            return new ListConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    CopyableBuilder<Builder, ListConfigurationsResponse> {
        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

