/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.SessionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponseApproverResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetSessionResponseApproverResponse> {
    private static final SdkField<String> APPROVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApproverId").getter(GetSessionResponseApproverResponse.getter(GetSessionResponseApproverResponse::approverId)).setter(GetSessionResponseApproverResponse.setter(Builder::approverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproverId").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentitySourceArn").getter(GetSessionResponseApproverResponse.getter(GetSessionResponseApproverResponse::identitySourceArn)).setter(GetSessionResponseApproverResponse.setter(Builder::identitySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentitySourceArn").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(GetSessionResponseApproverResponse.getter(GetSessionResponseApproverResponse::identityId)).setter(GetSessionResponseApproverResponse.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Response").getter(GetSessionResponseApproverResponse.getter(GetSessionResponseApproverResponse::responseAsString)).setter(GetSessionResponseApproverResponse.setter(Builder::response)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Response").build()}).build();
    private static final SdkField<Instant> RESPONSE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResponseTime").getter(GetSessionResponseApproverResponse.getter(GetSessionResponseApproverResponse::responseTime)).setter(GetSessionResponseApproverResponse.setter(Builder::responseTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVER_ID_FIELD, IDENTITY_SOURCE_ARN_FIELD, IDENTITY_ID_FIELD, RESPONSE_FIELD, RESPONSE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionResponseApproverResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String approverId;
    private final String identitySourceArn;
    private final String identityId;
    private final String response;
    private final Instant responseTime;

    private GetSessionResponseApproverResponse(BuilderImpl builder) {
        this.approverId = builder.approverId;
        this.identitySourceArn = builder.identitySourceArn;
        this.identityId = builder.identityId;
        this.response = builder.response;
        this.responseTime = builder.responseTime;
    }

    public final String approverId() {
        return this.approverId;
    }

    public final String identitySourceArn() {
        return this.identitySourceArn;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final SessionResponse response() {
        return SessionResponse.fromValue(this.response);
    }

    public final String responseAsString() {
        return this.response;
    }

    public final Instant responseTime() {
        return this.responseTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponseApproverResponse)) {
            return false;
        }
        GetSessionResponseApproverResponse other = (GetSessionResponseApproverResponse)obj;
        return Objects.equals(this.approverId(), other.approverId()) && Objects.equals(this.identitySourceArn(), other.identitySourceArn()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.responseAsString(), other.responseAsString()) && Objects.equals(this.responseTime(), other.responseTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionResponseApproverResponse").add("ApproverId", (Object)this.approverId()).add("IdentitySourceArn", (Object)this.identitySourceArn()).add("IdentityId", (Object)this.identityId()).add("Response", (Object)this.responseAsString()).add("ResponseTime", (Object)this.responseTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproverId": {
                return Optional.ofNullable(clazz.cast(this.approverId()));
            }
            case "IdentitySourceArn": {
                return Optional.ofNullable(clazz.cast(this.identitySourceArn()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "Response": {
                return Optional.ofNullable(clazz.cast(this.responseAsString()));
            }
            case "ResponseTime": {
                return Optional.ofNullable(clazz.cast(this.responseTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApproverId", APPROVER_ID_FIELD);
        map.put("IdentitySourceArn", IDENTITY_SOURCE_ARN_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("Response", RESPONSE_FIELD);
        map.put("ResponseTime", RESPONSE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponseApproverResponse, T> g) {
        return obj -> g.apply((GetSessionResponseApproverResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String approverId;
        private String identitySourceArn;
        private String identityId;
        private String response;
        private Instant responseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponseApproverResponse model) {
            this.approverId(model.approverId);
            this.identitySourceArn(model.identitySourceArn);
            this.identityId(model.identityId);
            this.response(model.response);
            this.responseTime(model.responseTime);
        }

        public final String getApproverId() {
            return this.approverId;
        }

        public final void setApproverId(String approverId) {
            this.approverId = approverId;
        }

        @Override
        public final Builder approverId(String approverId) {
            this.approverId = approverId;
            return this;
        }

        public final String getIdentitySourceArn() {
            return this.identitySourceArn;
        }

        public final void setIdentitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
        }

        @Override
        public final Builder identitySourceArn(String identitySourceArn) {
            this.identitySourceArn = identitySourceArn;
            return this;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getResponse() {
            return this.response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        @Override
        public final Builder response(SessionResponse response) {
            this.response(response == null ? null : response.toString());
            return this;
        }

        public final Instant getResponseTime() {
            return this.responseTime;
        }

        public final void setResponseTime(Instant responseTime) {
            this.responseTime = responseTime;
        }

        @Override
        public final Builder responseTime(Instant responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public GetSessionResponseApproverResponse build() {
            return new GetSessionResponseApproverResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetSessionResponseApproverResponse> {
        public Builder approverId(String var1);

        public Builder identitySourceArn(String var1);

        public Builder identityId(String var1);

        public Builder response(String var1);

        public Builder response(SessionResponse var1);

        public Builder responseTime(Instant var1);
    }
}

