/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Multi-party approval is a capability of <a href="http://aws.amazon.com/organizations">Organizations</a> that allows
 * you to protect a predefined list of operations through a distributed approval process. Use Multi-party approval to
 * establish approval workflows and transform security processes into team-based decisions.
 * </p>
 * <p>
 * <b>When to use Multi-party approval</b>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You need to align with the Zero Trust principle of "never trust, always verify"
 * </p>
 * </li>
 * <li>
 * <p>
 * You need to make sure that the right humans have access to the right things in the right way
 * </p>
 * </li>
 * <li>
 * <p>
 * You need distributed decision-making for sensitive or critical operations
 * </p>
 * </li>
 * <li>
 * <p>
 * You need to protect against unintended operations on sensitive or critical resources
 * </p>
 * </li>
 * <li>
 * <p>
 * You need formal reviews and approvals for auditing or compliance reasons
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/what-is.html">What is Multi-party
 * approval</a> in the <i>Multi-party approval User Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.mpa;