/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mpa.MpaAsyncClient;
import software.amazon.awssdk.services.mpa.internal.UserAgentUtils;
import software.amazon.awssdk.services.mpa.model.IdentitySourceForList;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesRequest;
import software.amazon.awssdk.services.mpa.model.ListIdentitySourcesResponse;

public class ListIdentitySourcesPublisher
implements SdkPublisher<ListIdentitySourcesResponse> {
    private final MpaAsyncClient client;
    private final ListIdentitySourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentitySourcesPublisher(MpaAsyncClient client, ListIdentitySourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentitySourcesPublisher(MpaAsyncClient client, ListIdentitySourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentitySourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentitySourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdentitySourceForList> identitySources() {
        Function<ListIdentitySourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.identitySources() != null) {
                return response.identitySources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdentitySourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdentitySourcesResponseFetcher
    implements AsyncPageFetcher<ListIdentitySourcesResponse> {
        private ListIdentitySourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentitySourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentitySourcesResponse> nextPage(ListIdentitySourcesResponse previousPage) {
            if (previousPage == null) {
                return ListIdentitySourcesPublisher.this.client.listIdentitySources(ListIdentitySourcesPublisher.this.firstRequest);
            }
            return ListIdentitySourcesPublisher.this.client.listIdentitySources((ListIdentitySourcesRequest)((Object)ListIdentitySourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

