/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mobile.model.MobileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectRequest
extends MobileRequest
implements ToCopyableBuilder<Builder, UpdateProjectRequest> {
    private static final SdkField<SdkBytes> CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("contents").getter(UpdateProjectRequest.getter(UpdateProjectRequest::contents)).setter(UpdateProjectRequest.setter(Builder::contents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(UpdateProjectRequest.getter(UpdateProjectRequest::projectId)).setter(UpdateProjectRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENTS_FIELD, PROJECT_ID_FIELD));
    private final SdkBytes contents;
    private final String projectId;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.contents = builder.contents;
        this.projectId = builder.projectId;
    }

    public final SdkBytes contents() {
        return this.contents;
    }

    public final String projectId() {
        return this.projectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contents());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)obj);
        return Objects.equals(this.contents(), other.contents()) && Objects.equals(this.projectId(), other.projectId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectRequest").add("Contents", (Object)this.contents()).add("ProjectId", (Object)this.projectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contents": {
                return Optional.ofNullable(clazz.cast(this.contents()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileRequest.BuilderImpl
    implements Builder {
        private SdkBytes contents;
        private String projectId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            this.contents(model.contents);
            this.projectId(model.projectId);
        }

        public final ByteBuffer getContents() {
            return this.contents == null ? null : this.contents.asByteBuffer();
        }

        @Override
        public final Builder contents(SdkBytes contents) {
            this.contents = StandardMemberCopier.copy((SdkBytes)contents);
            return this;
        }

        public final void setContents(ByteBuffer contents) {
            this.contents(contents == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)contents));
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectRequest> {
        public Builder contents(SdkBytes var1);

        public Builder projectId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

