/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mobile.model.MobileResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportProjectResponse
extends MobileResponse
implements ToCopyableBuilder<Builder, ExportProjectResponse> {
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportProjectResponse.getter(ExportProjectResponse::downloadUrl)).setter(ExportProjectResponse.setter(Builder::downloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()}).build();
    private static final SdkField<String> SHARE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportProjectResponse.getter(ExportProjectResponse::shareUrl)).setter(ExportProjectResponse.setter(Builder::shareUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareUrl").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportProjectResponse.getter(ExportProjectResponse::snapshotId)).setter(ExportProjectResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLOAD_URL_FIELD, SHARE_URL_FIELD, SNAPSHOT_ID_FIELD));
    private final String downloadUrl;
    private final String shareUrl;
    private final String snapshotId;

    private ExportProjectResponse(BuilderImpl builder) {
        super(builder);
        this.downloadUrl = builder.downloadUrl;
        this.shareUrl = builder.shareUrl;
        this.snapshotId = builder.snapshotId;
    }

    public String downloadUrl() {
        return this.downloadUrl;
    }

    public String shareUrl() {
        return this.shareUrl;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportProjectResponse)) {
            return false;
        }
        ExportProjectResponse other = (ExportProjectResponse)((Object)obj);
        return Objects.equals(this.downloadUrl(), other.downloadUrl()) && Objects.equals(this.shareUrl(), other.shareUrl()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public String toString() {
        return ToString.builder((String)"ExportProjectResponse").add("DownloadUrl", (Object)this.downloadUrl()).add("ShareUrl", (Object)this.shareUrl()).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "downloadUrl": {
                return Optional.ofNullable(clazz.cast(this.downloadUrl()));
            }
            case "shareUrl": {
                return Optional.ofNullable(clazz.cast(this.shareUrl()));
            }
            case "snapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportProjectResponse, T> g) {
        return obj -> g.apply((ExportProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileResponse.BuilderImpl
    implements Builder {
        private String downloadUrl;
        private String shareUrl;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportProjectResponse model) {
            super(model);
            this.downloadUrl(model.downloadUrl);
            this.shareUrl(model.shareUrl);
            this.snapshotId(model.snapshotId);
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public final String getShareUrl() {
            return this.shareUrl;
        }

        @Override
        public final Builder shareUrl(String shareUrl) {
            this.shareUrl = shareUrl;
            return this;
        }

        public final void setShareUrl(String shareUrl) {
            this.shareUrl = shareUrl;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public ExportProjectResponse build() {
            return new ExportProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportProjectResponse> {
        public Builder downloadUrl(String var1);

        public Builder shareUrl(String var1);

        public Builder snapshotId(String var1);
    }
}

