/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.PipelineType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineInfo> {
    private static final SdkField<String> PIPELINE_CONFIGURATION_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineConfigurationTimeStamp").getter(PipelineInfo.getter(PipelineInfo::pipelineConfigurationTimeStamp)).setter(PipelineInfo.setter(Builder::pipelineConfigurationTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfigurationTimeStamp").build()}).build();
    private static final SdkField<String> PIPELINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineType").getter(PipelineInfo.getter(PipelineInfo::pipelineTypeAsString)).setter(PipelineInfo.setter(Builder::pipelineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_CONFIGURATION_TIME_STAMP_FIELD, PIPELINE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineConfigurationTimeStamp;
    private final String pipelineType;

    private PipelineInfo(BuilderImpl builder) {
        this.pipelineConfigurationTimeStamp = builder.pipelineConfigurationTimeStamp;
        this.pipelineType = builder.pipelineType;
    }

    public final String pipelineConfigurationTimeStamp() {
        return this.pipelineConfigurationTimeStamp;
    }

    public final PipelineType pipelineType() {
        return PipelineType.fromValue(this.pipelineType);
    }

    public final String pipelineTypeAsString() {
        return this.pipelineType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineConfigurationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineInfo)) {
            return false;
        }
        PipelineInfo other = (PipelineInfo)obj;
        return Objects.equals(this.pipelineConfigurationTimeStamp(), other.pipelineConfigurationTimeStamp()) && Objects.equals(this.pipelineTypeAsString(), other.pipelineTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineInfo").add("PipelineConfigurationTimeStamp", (Object)this.pipelineConfigurationTimeStamp()).add("PipelineType", (Object)this.pipelineTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineConfigurationTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.pipelineConfigurationTimeStamp()));
            }
            case "pipelineType": {
                return Optional.ofNullable(clazz.cast(this.pipelineTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pipelineConfigurationTimeStamp", PIPELINE_CONFIGURATION_TIME_STAMP_FIELD);
        map.put("pipelineType", PIPELINE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineInfo, T> g) {
        return obj -> g.apply((PipelineInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineConfigurationTimeStamp;
        private String pipelineType;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineInfo model) {
            this.pipelineConfigurationTimeStamp(model.pipelineConfigurationTimeStamp);
            this.pipelineType(model.pipelineType);
        }

        public final String getPipelineConfigurationTimeStamp() {
            return this.pipelineConfigurationTimeStamp;
        }

        public final void setPipelineConfigurationTimeStamp(String pipelineConfigurationTimeStamp) {
            this.pipelineConfigurationTimeStamp = pipelineConfigurationTimeStamp;
        }

        @Override
        public final Builder pipelineConfigurationTimeStamp(String pipelineConfigurationTimeStamp) {
            this.pipelineConfigurationTimeStamp = pipelineConfigurationTimeStamp;
            return this;
        }

        public final String getPipelineType() {
            return this.pipelineType;
        }

        public final void setPipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
        }

        @Override
        public final Builder pipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        @Override
        public final Builder pipelineType(PipelineType pipelineType) {
            this.pipelineType(pipelineType == null ? null : pipelineType.toString());
            return this;
        }

        public PipelineInfo build() {
            return new PipelineInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineInfo> {
        public Builder pipelineConfigurationTimeStamp(String var1);

        public Builder pipelineType(String var1);

        public Builder pipelineType(PipelineType var1);
    }
}

