/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternSeveritySummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAntipatternSeveritySummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListStrategySummaryCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.RecommendationSet;
import software.amazon.awssdk.services.migrationhubstrategy.model.RunTimeAssessmentStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.S3Object;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerError;
import software.amazon.awssdk.services.migrationhubstrategy.model.StrategySummary;
import software.amazon.awssdk.services.migrationhubstrategy.model.SystemInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerDetail> {
    private static final SdkField<S3Object> ANTIPATTERN_REPORT_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antipatternReportS3Object").getter(ServerDetail.getter(ServerDetail::antipatternReportS3Object)).setter(ServerDetail.setter(Builder::antipatternReportS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportS3Object").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatus").getter(ServerDetail.getter(ServerDetail::antipatternReportStatusAsString)).setter(ServerDetail.setter(Builder::antipatternReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build()}).build();
    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("antipatternReportStatusMessage").getter(ServerDetail.getter(ServerDetail::antipatternReportStatusMessage)).setter(ServerDetail.setter(Builder::antipatternReportStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage").build()}).build();
    private static final SdkField<List<StrategySummary>> APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationComponentStrategySummary").getter(ServerDetail.getter(ServerDetail::applicationComponentStrategySummary)).setter(ServerDetail.setter(Builder::applicationComponentStrategySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentStrategySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StrategySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_COLLECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataCollectionStatus").getter(ServerDetail.getter(ServerDetail::dataCollectionStatusAsString)).setter(ServerDetail.setter(Builder::dataCollectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionStatus").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServerDetail.getter(ServerDetail::id)).setter(ServerDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_ANALYZED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAnalyzedTimestamp").getter(ServerDetail.getter(ServerDetail::lastAnalyzedTimestamp)).setter(ServerDetail.setter(Builder::lastAnalyzedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAnalyzedTimestamp").build()}).build();
    private static final SdkField<List<AntipatternSeveritySummary>> LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listAntipatternSeveritySummary").getter(ServerDetail.getter(ServerDetail::listAntipatternSeveritySummary)).setter(ServerDetail.setter(Builder::listAntipatternSeveritySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listAntipatternSeveritySummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AntipatternSeveritySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServerDetail.getter(ServerDetail::name)).setter(ServerDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RecommendationSet> RECOMMENDATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendationSet").getter(ServerDetail.getter(ServerDetail::recommendationSet)).setter(ServerDetail.setter(Builder::recommendationSet)).constructor(RecommendationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSet").build()}).build();
    private static final SdkField<ServerError> SERVER_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverError").getter(ServerDetail.getter(ServerDetail::serverError)).setter(ServerDetail.setter(Builder::serverError)).constructor(ServerError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverError").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverType").getter(ServerDetail.getter(ServerDetail::serverType)).setter(ServerDetail.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ServerDetail.getter(ServerDetail::statusMessage)).setter(ServerDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<SystemInfo> SYSTEM_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("systemInfo").getter(ServerDetail.getter(ServerDetail::systemInfo)).setter(ServerDetail.setter(Builder::systemInfo)).constructor(SystemInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANTIPATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD, APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD, DATA_COLLECTION_STATUS_FIELD, ID_FIELD, LAST_ANALYZED_TIMESTAMP_FIELD, LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD, NAME_FIELD, RECOMMENDATION_SET_FIELD, SERVER_ERROR_FIELD, SERVER_TYPE_FIELD, STATUS_MESSAGE_FIELD, SYSTEM_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("antipatternReportS3Object", ANTIPATTERN_REPORT_S3_OBJECT_FIELD);
            this.put("antipatternReportStatus", ANTIPATTERN_REPORT_STATUS_FIELD);
            this.put("antipatternReportStatusMessage", ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD);
            this.put("applicationComponentStrategySummary", APPLICATION_COMPONENT_STRATEGY_SUMMARY_FIELD);
            this.put("dataCollectionStatus", DATA_COLLECTION_STATUS_FIELD);
            this.put("id", ID_FIELD);
            this.put("lastAnalyzedTimestamp", LAST_ANALYZED_TIMESTAMP_FIELD);
            this.put("listAntipatternSeveritySummary", LIST_ANTIPATTERN_SEVERITY_SUMMARY_FIELD);
            this.put("name", NAME_FIELD);
            this.put("recommendationSet", RECOMMENDATION_SET_FIELD);
            this.put("serverError", SERVER_ERROR_FIELD);
            this.put("serverType", SERVER_TYPE_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("systemInfo", SYSTEM_INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final S3Object antipatternReportS3Object;
    private final String antipatternReportStatus;
    private final String antipatternReportStatusMessage;
    private final List<StrategySummary> applicationComponentStrategySummary;
    private final String dataCollectionStatus;
    private final String id;
    private final Instant lastAnalyzedTimestamp;
    private final List<AntipatternSeveritySummary> listAntipatternSeveritySummary;
    private final String name;
    private final RecommendationSet recommendationSet;
    private final ServerError serverError;
    private final String serverType;
    private final String statusMessage;
    private final SystemInfo systemInfo;

    private ServerDetail(BuilderImpl builder) {
        this.antipatternReportS3Object = builder.antipatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
        this.applicationComponentStrategySummary = builder.applicationComponentStrategySummary;
        this.dataCollectionStatus = builder.dataCollectionStatus;
        this.id = builder.id;
        this.lastAnalyzedTimestamp = builder.lastAnalyzedTimestamp;
        this.listAntipatternSeveritySummary = builder.listAntipatternSeveritySummary;
        this.name = builder.name;
        this.recommendationSet = builder.recommendationSet;
        this.serverError = builder.serverError;
        this.serverType = builder.serverType;
        this.statusMessage = builder.statusMessage;
        this.systemInfo = builder.systemInfo;
    }

    public final S3Object antipatternReportS3Object() {
        return this.antipatternReportS3Object;
    }

    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(this.antipatternReportStatus);
    }

    public final String antipatternReportStatusAsString() {
        return this.antipatternReportStatus;
    }

    public final String antipatternReportStatusMessage() {
        return this.antipatternReportStatusMessage;
    }

    public final boolean hasApplicationComponentStrategySummary() {
        return this.applicationComponentStrategySummary != null && !(this.applicationComponentStrategySummary instanceof SdkAutoConstructList);
    }

    public final List<StrategySummary> applicationComponentStrategySummary() {
        return this.applicationComponentStrategySummary;
    }

    public final RunTimeAssessmentStatus dataCollectionStatus() {
        return RunTimeAssessmentStatus.fromValue(this.dataCollectionStatus);
    }

    public final String dataCollectionStatusAsString() {
        return this.dataCollectionStatus;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastAnalyzedTimestamp() {
        return this.lastAnalyzedTimestamp;
    }

    public final boolean hasListAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary != null && !(this.listAntipatternSeveritySummary instanceof SdkAutoConstructList);
    }

    public final List<AntipatternSeveritySummary> listAntipatternSeveritySummary() {
        return this.listAntipatternSeveritySummary;
    }

    public final String name() {
        return this.name;
    }

    public final RecommendationSet recommendationSet() {
        return this.recommendationSet;
    }

    public final ServerError serverError() {
        return this.serverError;
    }

    public final String serverType() {
        return this.serverType;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final SystemInfo systemInfo() {
        return this.systemInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antipatternReportStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationComponentStrategySummary() ? this.applicationComponentStrategySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCollectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverError());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerDetail)) {
            return false;
        }
        ServerDetail other = (ServerDetail)obj;
        return Objects.equals(this.antipatternReportS3Object(), other.antipatternReportS3Object()) && Objects.equals(this.antipatternReportStatusAsString(), other.antipatternReportStatusAsString()) && Objects.equals(this.antipatternReportStatusMessage(), other.antipatternReportStatusMessage()) && this.hasApplicationComponentStrategySummary() == other.hasApplicationComponentStrategySummary() && Objects.equals(this.applicationComponentStrategySummary(), other.applicationComponentStrategySummary()) && Objects.equals(this.dataCollectionStatusAsString(), other.dataCollectionStatusAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastAnalyzedTimestamp(), other.lastAnalyzedTimestamp()) && this.hasListAntipatternSeveritySummary() == other.hasListAntipatternSeveritySummary() && Objects.equals(this.listAntipatternSeveritySummary(), other.listAntipatternSeveritySummary()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recommendationSet(), other.recommendationSet()) && Objects.equals(this.serverError(), other.serverError()) && Objects.equals(this.serverType(), other.serverType()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.systemInfo(), other.systemInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ServerDetail").add("AntipatternReportS3Object", (Object)this.antipatternReportS3Object()).add("AntipatternReportStatus", (Object)this.antipatternReportStatusAsString()).add("AntipatternReportStatusMessage", (Object)this.antipatternReportStatusMessage()).add("ApplicationComponentStrategySummary", this.hasApplicationComponentStrategySummary() ? this.applicationComponentStrategySummary() : null).add("DataCollectionStatus", (Object)this.dataCollectionStatusAsString()).add("Id", (Object)this.id()).add("LastAnalyzedTimestamp", (Object)this.lastAnalyzedTimestamp()).add("ListAntipatternSeveritySummary", this.hasListAntipatternSeveritySummary() ? this.listAntipatternSeveritySummary() : null).add("Name", (Object)this.name()).add("RecommendationSet", (Object)this.recommendationSet()).add("ServerError", (Object)this.serverError()).add("ServerType", (Object)this.serverType()).add("StatusMessage", (Object)this.statusMessage()).add("SystemInfo", (Object)this.systemInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "antipatternReportS3Object": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportS3Object()));
            }
            case "antipatternReportStatus": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusAsString()));
            }
            case "antipatternReportStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportStatusMessage()));
            }
            case "applicationComponentStrategySummary": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentStrategySummary()));
            }
            case "dataCollectionStatus": {
                return Optional.ofNullable(clazz.cast(this.dataCollectionStatusAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastAnalyzedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTimestamp()));
            }
            case "listAntipatternSeveritySummary": {
                return Optional.ofNullable(clazz.cast(this.listAntipatternSeveritySummary()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recommendationSet": {
                return Optional.ofNullable(clazz.cast(this.recommendationSet()));
            }
            case "serverError": {
                return Optional.ofNullable(clazz.cast(this.serverError()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverType()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "systemInfo": {
                return Optional.ofNullable(clazz.cast(this.systemInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServerDetail, T> g) {
        return obj -> g.apply((ServerDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object antipatternReportS3Object;
        private String antipatternReportStatus;
        private String antipatternReportStatusMessage;
        private List<StrategySummary> applicationComponentStrategySummary = DefaultSdkAutoConstructList.getInstance();
        private String dataCollectionStatus;
        private String id;
        private Instant lastAnalyzedTimestamp;
        private List<AntipatternSeveritySummary> listAntipatternSeveritySummary = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private RecommendationSet recommendationSet;
        private ServerError serverError;
        private String serverType;
        private String statusMessage;
        private SystemInfo systemInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerDetail model) {
            this.antipatternReportS3Object(model.antipatternReportS3Object);
            this.antipatternReportStatus(model.antipatternReportStatus);
            this.antipatternReportStatusMessage(model.antipatternReportStatusMessage);
            this.applicationComponentStrategySummary(model.applicationComponentStrategySummary);
            this.dataCollectionStatus(model.dataCollectionStatus);
            this.id(model.id);
            this.lastAnalyzedTimestamp(model.lastAnalyzedTimestamp);
            this.listAntipatternSeveritySummary(model.listAntipatternSeveritySummary);
            this.name(model.name);
            this.recommendationSet(model.recommendationSet);
            this.serverError(model.serverError);
            this.serverType(model.serverType);
            this.statusMessage(model.statusMessage);
            this.systemInfo(model.systemInfo);
        }

        public final S3Object.Builder getAntipatternReportS3Object() {
            return this.antipatternReportS3Object != null ? this.antipatternReportS3Object.toBuilder() : null;
        }

        public final void setAntipatternReportS3Object(S3Object.BuilderImpl antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object != null ? antipatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antipatternReportS3Object(S3Object antipatternReportS3Object) {
            this.antipatternReportS3Object = antipatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return this.antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return this.antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        public final List<StrategySummary.Builder> getApplicationComponentStrategySummary() {
            List<StrategySummary.Builder> result = ListStrategySummaryCopier.copyToBuilder(this.applicationComponentStrategySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentStrategySummary(Collection<StrategySummary.BuilderImpl> applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary = ListStrategySummaryCopier.copyFromBuilder(applicationComponentStrategySummary);
        }

        @Override
        public final Builder applicationComponentStrategySummary(Collection<StrategySummary> applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary = ListStrategySummaryCopier.copy(applicationComponentStrategySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategySummary(StrategySummary ... applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary(Arrays.asList(applicationComponentStrategySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategySummary(Consumer<StrategySummary.Builder> ... applicationComponentStrategySummary) {
            this.applicationComponentStrategySummary(Stream.of(applicationComponentStrategySummary).map(c -> (StrategySummary)((StrategySummary.Builder)StrategySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataCollectionStatus() {
            return this.dataCollectionStatus;
        }

        public final void setDataCollectionStatus(String dataCollectionStatus) {
            this.dataCollectionStatus = dataCollectionStatus;
        }

        @Override
        public final Builder dataCollectionStatus(String dataCollectionStatus) {
            this.dataCollectionStatus = dataCollectionStatus;
            return this;
        }

        @Override
        public final Builder dataCollectionStatus(RunTimeAssessmentStatus dataCollectionStatus) {
            this.dataCollectionStatus(dataCollectionStatus == null ? null : dataCollectionStatus.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastAnalyzedTimestamp() {
            return this.lastAnalyzedTimestamp;
        }

        public final void setLastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
        }

        @Override
        public final Builder lastAnalyzedTimestamp(Instant lastAnalyzedTimestamp) {
            this.lastAnalyzedTimestamp = lastAnalyzedTimestamp;
            return this;
        }

        public final List<AntipatternSeveritySummary.Builder> getListAntipatternSeveritySummary() {
            List<AntipatternSeveritySummary.Builder> result = ListAntipatternSeveritySummaryCopier.copyToBuilder(this.listAntipatternSeveritySummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListAntipatternSeveritySummary(Collection<AntipatternSeveritySummary.BuilderImpl> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copyFromBuilder(listAntipatternSeveritySummary);
        }

        @Override
        public final Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary = ListAntipatternSeveritySummaryCopier.copy(listAntipatternSeveritySummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Arrays.asList(listAntipatternSeveritySummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... listAntipatternSeveritySummary) {
            this.listAntipatternSeveritySummary(Stream.of(listAntipatternSeveritySummary).map(c -> (AntipatternSeveritySummary)((AntipatternSeveritySummary.Builder)AntipatternSeveritySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecommendationSet.Builder getRecommendationSet() {
            return this.recommendationSet != null ? this.recommendationSet.toBuilder() : null;
        }

        public final void setRecommendationSet(RecommendationSet.BuilderImpl recommendationSet) {
            this.recommendationSet = recommendationSet != null ? recommendationSet.build() : null;
        }

        @Override
        public final Builder recommendationSet(RecommendationSet recommendationSet) {
            this.recommendationSet = recommendationSet;
            return this;
        }

        public final ServerError.Builder getServerError() {
            return this.serverError != null ? this.serverError.toBuilder() : null;
        }

        public final void setServerError(ServerError.BuilderImpl serverError) {
            this.serverError = serverError != null ? serverError.build() : null;
        }

        @Override
        public final Builder serverError(ServerError serverError) {
            this.serverError = serverError;
            return this;
        }

        public final String getServerType() {
            return this.serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final SystemInfo.Builder getSystemInfo() {
            return this.systemInfo != null ? this.systemInfo.toBuilder() : null;
        }

        public final void setSystemInfo(SystemInfo.BuilderImpl systemInfo) {
            this.systemInfo = systemInfo != null ? systemInfo.build() : null;
        }

        @Override
        public final Builder systemInfo(SystemInfo systemInfo) {
            this.systemInfo = systemInfo;
            return this;
        }

        public ServerDetail build() {
            return new ServerDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerDetail> {
        public Builder antipatternReportS3Object(S3Object var1);

        default public Builder antipatternReportS3Object(Consumer<S3Object.Builder> antipatternReportS3Object) {
            return this.antipatternReportS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(antipatternReportS3Object)).build());
        }

        public Builder antipatternReportStatus(String var1);

        public Builder antipatternReportStatus(AntipatternReportStatus var1);

        public Builder antipatternReportStatusMessage(String var1);

        public Builder applicationComponentStrategySummary(Collection<StrategySummary> var1);

        public Builder applicationComponentStrategySummary(StrategySummary ... var1);

        public Builder applicationComponentStrategySummary(Consumer<StrategySummary.Builder> ... var1);

        public Builder dataCollectionStatus(String var1);

        public Builder dataCollectionStatus(RunTimeAssessmentStatus var1);

        public Builder id(String var1);

        public Builder lastAnalyzedTimestamp(Instant var1);

        public Builder listAntipatternSeveritySummary(Collection<AntipatternSeveritySummary> var1);

        public Builder listAntipatternSeveritySummary(AntipatternSeveritySummary ... var1);

        public Builder listAntipatternSeveritySummary(Consumer<AntipatternSeveritySummary.Builder> ... var1);

        public Builder name(String var1);

        public Builder recommendationSet(RecommendationSet var1);

        default public Builder recommendationSet(Consumer<RecommendationSet.Builder> recommendationSet) {
            return this.recommendationSet((RecommendationSet)((RecommendationSet.Builder)RecommendationSet.builder().applyMutation(recommendationSet)).build());
        }

        public Builder serverError(ServerError var1);

        default public Builder serverError(Consumer<ServerError.Builder> serverError) {
            return this.serverError((ServerError)((ServerError.Builder)ServerError.builder().applyMutation(serverError)).build());
        }

        public Builder serverType(String var1);

        public Builder statusMessage(String var1);

        public Builder systemInfo(SystemInfo var1);

        default public Builder systemInfo(Consumer<SystemInfo.Builder> systemInfo) {
            return this.systemInfo((SystemInfo)((SystemInfo.Builder)SystemInfo.builder().applyMutation(systemInfo)).build());
        }
    }
}

