/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.AppType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationComponentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationComponentSummary> {
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appType").getter(ApplicationComponentSummary.getter(ApplicationComponentSummary::appTypeAsString)).setter(ApplicationComponentSummary.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appType").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(ApplicationComponentSummary.getter(ApplicationComponentSummary::count)).setter(ApplicationComponentSummary.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_TYPE_FIELD, COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appType", APP_TYPE_FIELD);
            this.put("count", COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String appType;
    private final Integer count;

    private ApplicationComponentSummary(BuilderImpl builder) {
        this.appType = builder.appType;
        this.count = builder.count;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponentSummary)) {
            return false;
        }
        ApplicationComponentSummary other = (ApplicationComponentSummary)obj;
        return Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationComponentSummary").add("AppType", (Object)this.appTypeAsString()).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponentSummary, T> g) {
        return obj -> g.apply((ApplicationComponentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appType;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponentSummary model) {
            this.appType(model.appType);
            this.count(model.count);
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public ApplicationComponentSummary build() {
            return new ApplicationComponentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationComponentSummary> {
        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder count(Integer var1);
    }
}

