/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerOsType {
    WINDOWS_SERVER("WindowsServer"),
    AMAZON_LINUX("AmazonLinux"),
    END_OF_SUPPORT_WINDOWS_SERVER("EndOfSupportWindowsServer"),
    REDHAT("Redhat"),
    OTHER("Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerOsType> VALUE_MAP;
    private final String value;

    private ServerOsType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerOsType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerOsType> knownValues() {
        EnumSet<ServerOsType> knownValues = EnumSet.allOf(ServerOsType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerOsType.class, ServerOsType::toString);
    }
}

