/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportFileTaskStatus {
    IMPORT_IN_PROGRESS("ImportInProgress"),
    IMPORT_FAILED("ImportFailed"),
    IMPORT_PARTIAL_SUCCESS("ImportPartialSuccess"),
    IMPORT_SUCCESS("ImportSuccess"),
    DELETE_IN_PROGRESS("DeleteInProgress"),
    DELETE_FAILED("DeleteFailed"),
    DELETE_PARTIAL_SUCCESS("DeletePartialSuccess"),
    DELETE_SUCCESS("DeleteSuccess"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportFileTaskStatus> VALUE_MAP;
    private final String value;

    private ImportFileTaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportFileTaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportFileTaskStatus> knownValues() {
        EnumSet<ImportFileTaskStatus> knownValues = EnumSet.allOf(ImportFileTaskStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportFileTaskStatus.class, ImportFileTaskStatus::toString);
    }
}

