/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransformationToolName {
    APP2_CONTAINER("App2Container"),
    PORTING_ASSISTANT_FOR_NET("Porting Assistant For .NET"),
    END_OF_SUPPORT_MIGRATION("End of Support Migration"),
    WINDOWS_WEB_APPLICATION_MIGRATION_ASSISTANT("Windows Web Application Migration Assistant"),
    APPLICATION_MIGRATION_SERVICE("Application Migration Service"),
    STRATEGY_RECOMMENDATION_SUPPORT("Strategy Recommendation Support"),
    IN_PLACE_OPERATING_SYSTEM_UPGRADE("In Place Operating System Upgrade"),
    SCHEMA_CONVERSION_TOOL("Schema Conversion Tool"),
    DATABASE_MIGRATION_SERVICE("Database Migration Service"),
    NATIVE_SQL_SERVER_BACKUP_RESTORE("Native SQL Server Backup/Restore"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransformationToolName> VALUE_MAP;
    private final String value;

    private TransformationToolName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransformationToolName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransformationToolName> knownValues() {
        EnumSet<TransformationToolName> knownValues = EnumSet.allOf(TransformationToolName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransformationToolName.class, TransformationToolName::toString);
    }
}

