/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetDestination {
    NONE_SPECIFIED("None specified"),
    AWS_ELASTIC_BEAN_STALK("AWS Elastic BeanStalk"),
    AWS_FARGATE("AWS Fargate"),
    AMAZON_ELASTIC_CLOUD_COMPUTE_EC2("Amazon Elastic Cloud Compute (EC2)"),
    AMAZON_ELASTIC_CONTAINER_SERVICE_ECS("Amazon Elastic Container Service (ECS)"),
    AMAZON_ELASTIC_KUBERNETES_SERVICE_EKS("Amazon Elastic Kubernetes Service (EKS)"),
    AURORA_MY_SQL("Aurora MySQL"),
    AURORA_POSTGRE_SQL("Aurora PostgreSQL"),
    AMAZON_RELATIONAL_DATABASE_SERVICE_ON_MY_SQL("Amazon Relational Database Service on MySQL"),
    AMAZON_RELATIONAL_DATABASE_SERVICE_ON_POSTGRE_SQL("Amazon Relational Database Service on PostgreSQL"),
    AMAZON_DOCUMENT_DB("Amazon DocumentDB"),
    AMAZON_DYNAMO_DB("Amazon DynamoDB"),
    AMAZON_RELATIONAL_DATABASE_SERVICE("Amazon Relational Database Service"),
    BABELFISH_FOR_AURORA_POSTGRE_SQL("Babelfish for Aurora PostgreSQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetDestination> VALUE_MAP;
    private final String value;

    private TargetDestination(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetDestination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetDestination> knownValues() {
        EnumSet<TargetDestination> knownValues = EnumSet.allOf(TargetDestination.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetDestination.class, TargetDestination::toString);
    }
}

