/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.VersionControl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCode> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(SourceCode.getter(SourceCode::location)).setter(SourceCode.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(SourceCode.getter(SourceCode::sourceVersion)).setter(SourceCode.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<String> VERSION_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionControl").getter(SourceCode.getter(SourceCode::versionControlAsString)).setter(SourceCode.setter(Builder::versionControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionControl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, SOURCE_VERSION_FIELD, VERSION_CONTROL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String location;
    private final String sourceVersion;
    private final String versionControl;

    private SourceCode(BuilderImpl builder) {
        this.location = builder.location;
        this.sourceVersion = builder.sourceVersion;
        this.versionControl = builder.versionControl;
    }

    public final String location() {
        return this.location;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final VersionControl versionControl() {
        return VersionControl.fromValue(this.versionControl);
    }

    public final String versionControlAsString() {
        return this.versionControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionControlAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCode)) {
            return false;
        }
        SourceCode other = (SourceCode)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.versionControlAsString(), other.versionControlAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SourceCode").add("Location", (Object)this.location()).add("SourceVersion", (Object)this.sourceVersion()).add("VersionControl", (Object)this.versionControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "versionControl": {
                return Optional.ofNullable(clazz.cast(this.versionControlAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCode, T> g) {
        return obj -> g.apply((SourceCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String sourceVersion;
        private String versionControl;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCode model) {
            this.location(model.location);
            this.sourceVersion(model.sourceVersion);
            this.versionControl(model.versionControl);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        @Transient
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final String getVersionControl() {
            return this.versionControl;
        }

        public final void setVersionControl(String versionControl) {
            this.versionControl = versionControl;
        }

        @Override
        @Transient
        public final Builder versionControl(String versionControl) {
            this.versionControl = versionControl;
            return this;
        }

        @Override
        @Transient
        public final Builder versionControl(VersionControl versionControl) {
            this.versionControl(versionControl == null ? null : versionControl.toString());
            return this;
        }

        public SourceCode build() {
            return new SourceCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCode> {
        public Builder location(String var1);

        public Builder sourceVersion(String var1);

        public Builder versionControl(String var1);

        public Builder versionControl(VersionControl var1);
    }
}

