/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.Strategy;
import software.amazon.awssdk.services.migrationhubstrategy.model.TargetDestination;
import software.amazon.awssdk.services.migrationhubstrategy.model.TransformationTool;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSet> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(RecommendationSet.getter(RecommendationSet::strategyAsString)).setter(RecommendationSet.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final SdkField<String> TARGET_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetDestination").getter(RecommendationSet.getter(RecommendationSet::targetDestinationAsString)).setter(RecommendationSet.setter(Builder::targetDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDestination").build()}).build();
    private static final SdkField<TransformationTool> TRANSFORMATION_TOOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("transformationTool").getter(RecommendationSet.getter(RecommendationSet::transformationTool)).setter(RecommendationSet.setter(Builder::transformationTool)).constructor(TransformationTool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationTool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, TARGET_DESTINATION_FIELD, TRANSFORMATION_TOOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final String targetDestination;
    private final TransformationTool transformationTool;

    private RecommendationSet(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.targetDestination = builder.targetDestination;
        this.transformationTool = builder.transformationTool;
    }

    public final Strategy strategy() {
        return Strategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final TargetDestination targetDestination() {
        return TargetDestination.fromValue(this.targetDestination);
    }

    public final String targetDestinationAsString() {
        return this.targetDestination;
    }

    public final TransformationTool transformationTool() {
        return this.transformationTool;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationTool());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSet)) {
            return false;
        }
        RecommendationSet other = (RecommendationSet)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.targetDestinationAsString(), other.targetDestinationAsString()) && Objects.equals(this.transformationTool(), other.transformationTool());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSet").add("Strategy", (Object)this.strategyAsString()).add("TargetDestination", (Object)this.targetDestinationAsString()).add("TransformationTool", (Object)this.transformationTool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "targetDestination": {
                return Optional.ofNullable(clazz.cast(this.targetDestinationAsString()));
            }
            case "transformationTool": {
                return Optional.ofNullable(clazz.cast(this.transformationTool()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSet, T> g) {
        return obj -> g.apply((RecommendationSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private String targetDestination;
        private TransformationTool transformationTool;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSet model) {
            this.strategy(model.strategy);
            this.targetDestination(model.targetDestination);
            this.transformationTool(model.transformationTool);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final String getTargetDestination() {
            return this.targetDestination;
        }

        public final void setTargetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
        }

        @Override
        public final Builder targetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        @Override
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination(targetDestination == null ? null : targetDestination.toString());
            return this;
        }

        public final TransformationTool.Builder getTransformationTool() {
            return this.transformationTool != null ? this.transformationTool.toBuilder() : null;
        }

        public final void setTransformationTool(TransformationTool.BuilderImpl transformationTool) {
            this.transformationTool = transformationTool != null ? transformationTool.build() : null;
        }

        @Override
        public final Builder transformationTool(TransformationTool transformationTool) {
            this.transformationTool = transformationTool;
            return this;
        }

        public RecommendationSet build() {
            return new RecommendationSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSet> {
        public Builder strategy(String var1);

        public Builder strategy(Strategy var1);

        public Builder targetDestination(String var1);

        public Builder targetDestination(TargetDestination var1);

        public Builder transformationTool(TransformationTool var1);

        default public Builder transformationTool(Consumer<TransformationTool.Builder> transformationTool) {
            return this.transformationTool((TransformationTool)((TransformationTool.Builder)TransformationTool.builder().applyMutation(transformationTool)).build());
        }
    }
}

