/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.InclusionStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.SourceCode;
import software.amazon.awssdk.services.migrationhubstrategy.model.SourceCodeListCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.StrategyOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationComponentConfigRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, UpdateApplicationComponentConfigRequest> {
    private static final SdkField<String> APPLICATION_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationComponentId").getter(UpdateApplicationComponentConfigRequest.getter(UpdateApplicationComponentConfigRequest::applicationComponentId)).setter(UpdateApplicationComponentConfigRequest.setter(Builder::applicationComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentId").build()}).build();
    private static final SdkField<String> INCLUSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inclusionStatus").getter(UpdateApplicationComponentConfigRequest.getter(UpdateApplicationComponentConfigRequest::inclusionStatusAsString)).setter(UpdateApplicationComponentConfigRequest.setter(Builder::inclusionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionStatus").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretsManagerKey").getter(UpdateApplicationComponentConfigRequest.getter(UpdateApplicationComponentConfigRequest::secretsManagerKey)).setter(UpdateApplicationComponentConfigRequest.setter(Builder::secretsManagerKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerKey").build()}).build();
    private static final SdkField<List<SourceCode>> SOURCE_CODE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceCodeList").getter(UpdateApplicationComponentConfigRequest.getter(UpdateApplicationComponentConfigRequest::sourceCodeList)).setter(UpdateApplicationComponentConfigRequest.setter(Builder::sourceCodeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StrategyOption> STRATEGY_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("strategyOption").getter(UpdateApplicationComponentConfigRequest.getter(UpdateApplicationComponentConfigRequest::strategyOption)).setter(UpdateApplicationComponentConfigRequest.setter(Builder::strategyOption)).constructor(StrategyOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_ID_FIELD, INCLUSION_STATUS_FIELD, SECRETS_MANAGER_KEY_FIELD, SOURCE_CODE_LIST_FIELD, STRATEGY_OPTION_FIELD));
    private final String applicationComponentId;
    private final String inclusionStatus;
    private final String secretsManagerKey;
    private final List<SourceCode> sourceCodeList;
    private final StrategyOption strategyOption;

    private UpdateApplicationComponentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.applicationComponentId = builder.applicationComponentId;
        this.inclusionStatus = builder.inclusionStatus;
        this.secretsManagerKey = builder.secretsManagerKey;
        this.sourceCodeList = builder.sourceCodeList;
        this.strategyOption = builder.strategyOption;
    }

    public final String applicationComponentId() {
        return this.applicationComponentId;
    }

    public final InclusionStatus inclusionStatus() {
        return InclusionStatus.fromValue(this.inclusionStatus);
    }

    public final String inclusionStatusAsString() {
        return this.inclusionStatus;
    }

    public final String secretsManagerKey() {
        return this.secretsManagerKey;
    }

    public final boolean hasSourceCodeList() {
        return this.sourceCodeList != null && !(this.sourceCodeList instanceof SdkAutoConstructList);
    }

    public final List<SourceCode> sourceCodeList() {
        return this.sourceCodeList;
    }

    public final StrategyOption strategyOption() {
        return this.strategyOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceCodeList() ? this.sourceCodeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationComponentConfigRequest)) {
            return false;
        }
        UpdateApplicationComponentConfigRequest other = (UpdateApplicationComponentConfigRequest)((Object)obj);
        return Objects.equals(this.applicationComponentId(), other.applicationComponentId()) && Objects.equals(this.inclusionStatusAsString(), other.inclusionStatusAsString()) && Objects.equals(this.secretsManagerKey(), other.secretsManagerKey()) && this.hasSourceCodeList() == other.hasSourceCodeList() && Objects.equals(this.sourceCodeList(), other.sourceCodeList()) && Objects.equals(this.strategyOption(), other.strategyOption());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationComponentConfigRequest").add("ApplicationComponentId", (Object)this.applicationComponentId()).add("InclusionStatus", (Object)this.inclusionStatusAsString()).add("SecretsManagerKey", (Object)(this.secretsManagerKey() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceCodeList", this.hasSourceCodeList() ? this.sourceCodeList() : null).add("StrategyOption", (Object)this.strategyOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationComponentId": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentId()));
            }
            case "inclusionStatus": {
                return Optional.ofNullable(clazz.cast(this.inclusionStatusAsString()));
            }
            case "secretsManagerKey": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerKey()));
            }
            case "sourceCodeList": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeList()));
            }
            case "strategyOption": {
                return Optional.ofNullable(clazz.cast(this.strategyOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationComponentConfigRequest, T> g) {
        return obj -> g.apply((UpdateApplicationComponentConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String applicationComponentId;
        private String inclusionStatus;
        private String secretsManagerKey;
        private List<SourceCode> sourceCodeList = DefaultSdkAutoConstructList.getInstance();
        private StrategyOption strategyOption;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationComponentConfigRequest model) {
            super(model);
            this.applicationComponentId(model.applicationComponentId);
            this.inclusionStatus(model.inclusionStatus);
            this.secretsManagerKey(model.secretsManagerKey);
            this.sourceCodeList(model.sourceCodeList);
            this.strategyOption(model.strategyOption);
        }

        public final String getApplicationComponentId() {
            return this.applicationComponentId;
        }

        public final void setApplicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
        }

        @Override
        public final Builder applicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
            return this;
        }

        public final String getInclusionStatus() {
            return this.inclusionStatus;
        }

        public final void setInclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
        }

        @Override
        public final Builder inclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
            return this;
        }

        @Override
        public final Builder inclusionStatus(InclusionStatus inclusionStatus) {
            this.inclusionStatus(inclusionStatus == null ? null : inclusionStatus.toString());
            return this;
        }

        public final String getSecretsManagerKey() {
            return this.secretsManagerKey;
        }

        public final void setSecretsManagerKey(String secretsManagerKey) {
            this.secretsManagerKey = secretsManagerKey;
        }

        @Override
        public final Builder secretsManagerKey(String secretsManagerKey) {
            this.secretsManagerKey = secretsManagerKey;
            return this;
        }

        public final List<SourceCode.Builder> getSourceCodeList() {
            List<SourceCode.Builder> result = SourceCodeListCopier.copyToBuilder(this.sourceCodeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceCodeList(Collection<SourceCode.BuilderImpl> sourceCodeList) {
            this.sourceCodeList = SourceCodeListCopier.copyFromBuilder(sourceCodeList);
        }

        @Override
        public final Builder sourceCodeList(Collection<SourceCode> sourceCodeList) {
            this.sourceCodeList = SourceCodeListCopier.copy(sourceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeList(SourceCode ... sourceCodeList) {
            this.sourceCodeList(Arrays.asList(sourceCodeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeList(Consumer<SourceCode.Builder> ... sourceCodeList) {
            this.sourceCodeList(Stream.of(sourceCodeList).map(c -> (SourceCode)((SourceCode.Builder)SourceCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StrategyOption.Builder getStrategyOption() {
            return this.strategyOption != null ? this.strategyOption.toBuilder() : null;
        }

        public final void setStrategyOption(StrategyOption.BuilderImpl strategyOption) {
            this.strategyOption = strategyOption != null ? strategyOption.build() : null;
        }

        @Override
        public final Builder strategyOption(StrategyOption strategyOption) {
            this.strategyOption = strategyOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationComponentConfigRequest build() {
            return new UpdateApplicationComponentConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationComponentConfigRequest> {
        public Builder applicationComponentId(String var1);

        public Builder inclusionStatus(String var1);

        public Builder inclusionStatus(InclusionStatus var1);

        public Builder secretsManagerKey(String var1);

        public Builder sourceCodeList(Collection<SourceCode> var1);

        public Builder sourceCodeList(SourceCode ... var1);

        public Builder sourceCodeList(Consumer<SourceCode.Builder> ... var1);

        public Builder strategyOption(StrategyOption var1);

        default public Builder strategyOption(Consumer<StrategyOption.Builder> strategyOption) {
            return this.strategyOption((StrategyOption)((StrategyOption.Builder)StrategyOption.builder().applyMutation(strategyOption)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

