/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InclusionStatus {
    EXCLUDE_FROM_ASSESSMENT("excludeFromAssessment"),
    INCLUDE_IN_ASSESSMENT("includeInAssessment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InclusionStatus> VALUE_MAP;
    private final String value;

    private InclusionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InclusionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InclusionStatus> knownValues() {
        EnumSet<InclusionStatus> knownValues = EnumSet.allOf(InclusionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InclusionStatus.class, InclusionStatus::toString);
    }
}

