/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.CidrBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentVpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentVpc> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(EnvironmentVpc.getter(EnvironmentVpc::accountId)).setter(EnvironmentVpc.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<String>> CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlocks").getter(EnvironmentVpc.getter(EnvironmentVpc::cidrBlocks)).setter(EnvironmentVpc.setter(Builder::cidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EnvironmentVpc.getter(EnvironmentVpc::createdTime)).setter(EnvironmentVpc.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(EnvironmentVpc.getter(EnvironmentVpc::environmentId)).setter(EnvironmentVpc.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(EnvironmentVpc.getter(EnvironmentVpc::lastUpdatedTime)).setter(EnvironmentVpc.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(EnvironmentVpc.getter(EnvironmentVpc::vpcId)).setter(EnvironmentVpc.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> VPC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcName").getter(EnvironmentVpc.getter(EnvironmentVpc::vpcName)).setter(EnvironmentVpc.setter(Builder::vpcName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CIDR_BLOCKS_FIELD, CREATED_TIME_FIELD, ENVIRONMENT_ID_FIELD, LAST_UPDATED_TIME_FIELD, VPC_ID_FIELD, VPC_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("CidrBlocks", CIDR_BLOCKS_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("VpcName", VPC_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final List<String> cidrBlocks;
    private final Instant createdTime;
    private final String environmentId;
    private final Instant lastUpdatedTime;
    private final String vpcId;
    private final String vpcName;

    private EnvironmentVpc(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.cidrBlocks = builder.cidrBlocks;
        this.createdTime = builder.createdTime;
        this.environmentId = builder.environmentId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.vpcId = builder.vpcId;
        this.vpcName = builder.vpcName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasCidrBlocks() {
        return this.cidrBlocks != null && !(this.cidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> cidrBlocks() {
        return this.cidrBlocks;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String vpcName() {
        return this.vpcName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlocks() ? this.cidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVpc)) {
            return false;
        }
        EnvironmentVpc other = (EnvironmentVpc)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasCidrBlocks() == other.hasCidrBlocks() && Objects.equals(this.cidrBlocks(), other.cidrBlocks()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcName(), other.vpcName());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentVpc").add("AccountId", (Object)this.accountId()).add("CidrBlocks", this.hasCidrBlocks() ? this.cidrBlocks() : null).add("CreatedTime", (Object)this.createdTime()).add("EnvironmentId", (Object)this.environmentId()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("VpcId", (Object)this.vpcId()).add("VpcName", (Object)this.vpcName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.cidrBlocks()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcName": {
                return Optional.ofNullable(clazz.cast(this.vpcName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentVpc, T> g) {
        return obj -> g.apply((EnvironmentVpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> cidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private String environmentId;
        private Instant lastUpdatedTime;
        private String vpcId;
        private String vpcName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVpc model) {
            this.accountId(model.accountId);
            this.cidrBlocks(model.cidrBlocks);
            this.createdTime(model.createdTime);
            this.environmentId(model.environmentId);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.vpcId(model.vpcId);
            this.vpcName(model.vpcName);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getCidrBlocks() {
            if (this.cidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrBlocks;
        }

        public final void setCidrBlocks(Collection<String> cidrBlocks) {
            this.cidrBlocks = CidrBlocksCopier.copy(cidrBlocks);
        }

        @Override
        public final Builder cidrBlocks(Collection<String> cidrBlocks) {
            this.cidrBlocks = CidrBlocksCopier.copy(cidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(String ... cidrBlocks) {
            this.cidrBlocks(Arrays.asList(cidrBlocks));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcName() {
            return this.vpcName;
        }

        public final void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        @Override
        public final Builder vpcName(String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        public EnvironmentVpc build() {
            return new EnvironmentVpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentVpc> {
        public Builder accountId(String var1);

        public Builder cidrBlocks(Collection<String> var1);

        public Builder cidrBlocks(String ... var1);

        public Builder createdTime(Instant var1);

        public Builder environmentId(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder vpcId(String var1);

        public Builder vpcName(String var1);
    }
}

