/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponseOutputsListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Owner;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowStepResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetWorkflowStepResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::name)).setter(GetWorkflowStepResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepGroupId").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::stepGroupId)).setter(GetWorkflowStepResponse.setter(Builder::stepGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::workflowId)).setter(GetWorkflowStepResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::stepId)).setter(GetWorkflowStepResponse.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::description)).setter(GetWorkflowStepResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepActionType").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::stepActionTypeAsString)).setter(GetWorkflowStepResponse.setter(Builder::stepActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::ownerAsString)).setter(GetWorkflowStepResponse.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<WorkflowStepAutomationConfiguration> WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowStepAutomationConfiguration").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::workflowStepAutomationConfiguration)).setter(GetWorkflowStepResponse.setter(Builder::workflowStepAutomationConfiguration)).constructor(WorkflowStepAutomationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowStepAutomationConfiguration").build()}).build();
    private static final SdkField<List<String>> STEP_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepTarget").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::stepTarget)).setter(GetWorkflowStepResponse.setter(Builder::stepTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTarget").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorkflowStepOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::outputs)).setter(GetWorkflowStepResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStepOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::previous)).setter(GetWorkflowStepResponse.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::next)).setter(GetWorkflowStepResponse.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::statusAsString)).setter(GetWorkflowStepResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::statusMessage)).setter(GetWorkflowStepResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> SCRIPT_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptOutputLocation").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::scriptOutputLocation)).setter(GetWorkflowStepResponse.setter(Builder::scriptOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptOutputLocation").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::creationTime)).setter(GetWorkflowStepResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStartTime").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::lastStartTime)).setter(GetWorkflowStepResponse.setter(Builder::lastStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::endTime)).setter(GetWorkflowStepResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Integer> NO_OF_SRV_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noOfSrvCompleted").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::noOfSrvCompleted)).setter(GetWorkflowStepResponse.setter(Builder::noOfSrvCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvCompleted").build()}).build();
    private static final SdkField<Integer> NO_OF_SRV_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noOfSrvFailed").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::noOfSrvFailed)).setter(GetWorkflowStepResponse.setter(Builder::noOfSrvFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noOfSrvFailed").build()}).build();
    private static final SdkField<Integer> TOTAL_NO_OF_SRV_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalNoOfSrv").getter(GetWorkflowStepResponse.getter(GetWorkflowStepResponse::totalNoOfSrv)).setter(GetWorkflowStepResponse.setter(Builder::totalNoOfSrv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNoOfSrv").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STEP_GROUP_ID_FIELD, WORKFLOW_ID_FIELD, STEP_ID_FIELD, DESCRIPTION_FIELD, STEP_ACTION_TYPE_FIELD, OWNER_FIELD, WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD, STEP_TARGET_FIELD, OUTPUTS_FIELD, PREVIOUS_FIELD, NEXT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, SCRIPT_OUTPUT_LOCATION_FIELD, CREATION_TIME_FIELD, LAST_START_TIME_FIELD, END_TIME_FIELD, NO_OF_SRV_COMPLETED_FIELD, NO_OF_SRV_FAILED_FIELD, TOTAL_NO_OF_SRV_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowStepResponse.memberNameToFieldInitializer();
    private final String name;
    private final String stepGroupId;
    private final String workflowId;
    private final String stepId;
    private final String description;
    private final String stepActionType;
    private final String owner;
    private final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;
    private final List<String> stepTarget;
    private final List<WorkflowStepOutput> outputs;
    private final List<String> previous;
    private final List<String> next;
    private final String status;
    private final String statusMessage;
    private final String scriptOutputLocation;
    private final Instant creationTime;
    private final Instant lastStartTime;
    private final Instant endTime;
    private final Integer noOfSrvCompleted;
    private final Integer noOfSrvFailed;
    private final Integer totalNoOfSrv;

    private GetWorkflowStepResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stepGroupId = builder.stepGroupId;
        this.workflowId = builder.workflowId;
        this.stepId = builder.stepId;
        this.description = builder.description;
        this.stepActionType = builder.stepActionType;
        this.owner = builder.owner;
        this.workflowStepAutomationConfiguration = builder.workflowStepAutomationConfiguration;
        this.stepTarget = builder.stepTarget;
        this.outputs = builder.outputs;
        this.previous = builder.previous;
        this.next = builder.next;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.scriptOutputLocation = builder.scriptOutputLocation;
        this.creationTime = builder.creationTime;
        this.lastStartTime = builder.lastStartTime;
        this.endTime = builder.endTime;
        this.noOfSrvCompleted = builder.noOfSrvCompleted;
        this.noOfSrvFailed = builder.noOfSrvFailed;
        this.totalNoOfSrv = builder.totalNoOfSrv;
    }

    public final String name() {
        return this.name;
    }

    public final String stepGroupId() {
        return this.stepGroupId;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String description() {
        return this.description;
    }

    public final StepActionType stepActionType() {
        return StepActionType.fromValue(this.stepActionType);
    }

    public final String stepActionTypeAsString() {
        return this.stepActionType;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration() {
        return this.workflowStepAutomationConfiguration;
    }

    public final boolean hasStepTarget() {
        return this.stepTarget != null && !(this.stepTarget instanceof SdkAutoConstructList);
    }

    public final List<String> stepTarget() {
        return this.stepTarget;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStepOutput> outputs() {
        return this.outputs;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    public final StepStatus status() {
        return StepStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String scriptOutputLocation() {
        return this.scriptOutputLocation;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastStartTime() {
        return this.lastStartTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer noOfSrvCompleted() {
        return this.noOfSrvCompleted;
    }

    public final Integer noOfSrvFailed() {
        return this.noOfSrvFailed;
    }

    public final Integer totalNoOfSrv() {
        return this.totalNoOfSrv;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowStepAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepTarget() ? this.stepTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.noOfSrvCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.noOfSrvFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNoOfSrv());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepResponse)) {
            return false;
        }
        GetWorkflowStepResponse other = (GetWorkflowStepResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stepGroupId(), other.stepGroupId()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stepActionTypeAsString(), other.stepActionTypeAsString()) && Objects.equals(this.ownerAsString(), other.ownerAsString()) && Objects.equals(this.workflowStepAutomationConfiguration(), other.workflowStepAutomationConfiguration()) && this.hasStepTarget() == other.hasStepTarget() && Objects.equals(this.stepTarget(), other.stepTarget()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.scriptOutputLocation(), other.scriptOutputLocation()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastStartTime(), other.lastStartTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.noOfSrvCompleted(), other.noOfSrvCompleted()) && Objects.equals(this.noOfSrvFailed(), other.noOfSrvFailed()) && Objects.equals(this.totalNoOfSrv(), other.totalNoOfSrv());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowStepResponse").add("Name", (Object)this.name()).add("StepGroupId", (Object)this.stepGroupId()).add("WorkflowId", (Object)this.workflowId()).add("StepId", (Object)this.stepId()).add("Description", (Object)this.description()).add("StepActionType", (Object)this.stepActionTypeAsString()).add("Owner", (Object)this.ownerAsString()).add("WorkflowStepAutomationConfiguration", (Object)this.workflowStepAutomationConfiguration()).add("StepTarget", this.hasStepTarget() ? this.stepTarget() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ScriptOutputLocation", (Object)this.scriptOutputLocation()).add("CreationTime", (Object)this.creationTime()).add("LastStartTime", (Object)this.lastStartTime()).add("EndTime", (Object)this.endTime()).add("NoOfSrvCompleted", (Object)this.noOfSrvCompleted()).add("NoOfSrvFailed", (Object)this.noOfSrvFailed()).add("TotalNoOfSrv", (Object)this.totalNoOfSrv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stepGroupId": {
                return Optional.ofNullable(clazz.cast(this.stepGroupId()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "stepActionType": {
                return Optional.ofNullable(clazz.cast(this.stepActionTypeAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "workflowStepAutomationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workflowStepAutomationConfiguration()));
            }
            case "stepTarget": {
                return Optional.ofNullable(clazz.cast(this.stepTarget()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "scriptOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.scriptOutputLocation()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastStartTime": {
                return Optional.ofNullable(clazz.cast(this.lastStartTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "noOfSrvCompleted": {
                return Optional.ofNullable(clazz.cast(this.noOfSrvCompleted()));
            }
            case "noOfSrvFailed": {
                return Optional.ofNullable(clazz.cast(this.noOfSrvFailed()));
            }
            case "totalNoOfSrv": {
                return Optional.ofNullable(clazz.cast(this.totalNoOfSrv()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("stepGroupId", STEP_GROUP_ID_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("stepActionType", STEP_ACTION_TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("workflowStepAutomationConfiguration", WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD);
        map.put("stepTarget", STEP_TARGET_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("scriptOutputLocation", SCRIPT_OUTPUT_LOCATION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("noOfSrvCompleted", NO_OF_SRV_COMPLETED_FIELD);
        map.put("noOfSrvFailed", NO_OF_SRV_FAILED_FIELD);
        map.put("totalNoOfSrv", TOTAL_NO_OF_SRV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowStepResponse, T> g) {
        return obj -> g.apply((GetWorkflowStepResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String name;
        private String stepGroupId;
        private String workflowId;
        private String stepId;
        private String description;
        private String stepActionType;
        private String owner;
        private WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;
        private List<String> stepTarget = DefaultSdkAutoConstructList.getInstance();
        private List<WorkflowStepOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;
        private String scriptOutputLocation;
        private Instant creationTime;
        private Instant lastStartTime;
        private Instant endTime;
        private Integer noOfSrvCompleted;
        private Integer noOfSrvFailed;
        private Integer totalNoOfSrv;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowStepResponse model) {
            super(model);
            this.name(model.name);
            this.stepGroupId(model.stepGroupId);
            this.workflowId(model.workflowId);
            this.stepId(model.stepId);
            this.description(model.description);
            this.stepActionType(model.stepActionType);
            this.owner(model.owner);
            this.workflowStepAutomationConfiguration(model.workflowStepAutomationConfiguration);
            this.stepTarget(model.stepTarget);
            this.outputs(model.outputs);
            this.previous(model.previous);
            this.next(model.next);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.scriptOutputLocation(model.scriptOutputLocation);
            this.creationTime(model.creationTime);
            this.lastStartTime(model.lastStartTime);
            this.endTime(model.endTime);
            this.noOfSrvCompleted(model.noOfSrvCompleted);
            this.noOfSrvFailed(model.noOfSrvFailed);
            this.totalNoOfSrv(model.totalNoOfSrv);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStepGroupId() {
            return this.stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStepActionType() {
            return this.stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final WorkflowStepAutomationConfiguration.Builder getWorkflowStepAutomationConfiguration() {
            return this.workflowStepAutomationConfiguration != null ? this.workflowStepAutomationConfiguration.toBuilder() : null;
        }

        public final void setWorkflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration.BuilderImpl workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration != null ? workflowStepAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration;
            return this;
        }

        public final Collection<String> getStepTarget() {
            if (this.stepTarget instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepTarget;
        }

        public final void setStepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
        }

        @Override
        public final Builder stepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTarget(String ... stepTarget) {
            this.stepTarget(Arrays.asList(stepTarget));
            return this;
        }

        public final List<WorkflowStepOutput.Builder> getOutputs() {
            List<WorkflowStepOutput.Builder> result = GetWorkflowStepResponseOutputsListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<WorkflowStepOutput.BuilderImpl> outputs) {
            this.outputs = GetWorkflowStepResponseOutputsListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<WorkflowStepOutput> outputs) {
            this.outputs = GetWorkflowStepResponseOutputsListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(WorkflowStepOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<WorkflowStepOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (WorkflowStepOutput)((WorkflowStepOutput.Builder)WorkflowStepOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getScriptOutputLocation() {
            return this.scriptOutputLocation;
        }

        public final void setScriptOutputLocation(String scriptOutputLocation) {
            this.scriptOutputLocation = scriptOutputLocation;
        }

        @Override
        public final Builder scriptOutputLocation(String scriptOutputLocation) {
            this.scriptOutputLocation = scriptOutputLocation;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastStartTime() {
            return this.lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getNoOfSrvCompleted() {
            return this.noOfSrvCompleted;
        }

        public final void setNoOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
        }

        @Override
        public final Builder noOfSrvCompleted(Integer noOfSrvCompleted) {
            this.noOfSrvCompleted = noOfSrvCompleted;
            return this;
        }

        public final Integer getNoOfSrvFailed() {
            return this.noOfSrvFailed;
        }

        public final void setNoOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
        }

        @Override
        public final Builder noOfSrvFailed(Integer noOfSrvFailed) {
            this.noOfSrvFailed = noOfSrvFailed;
            return this;
        }

        public final Integer getTotalNoOfSrv() {
            return this.totalNoOfSrv;
        }

        public final void setTotalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
        }

        @Override
        public final Builder totalNoOfSrv(Integer totalNoOfSrv) {
            this.totalNoOfSrv = totalNoOfSrv;
            return this;
        }

        @Override
        public GetWorkflowStepResponse build() {
            return new GetWorkflowStepResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowStepResponse> {
        public Builder name(String var1);

        public Builder stepGroupId(String var1);

        public Builder workflowId(String var1);

        public Builder stepId(String var1);

        public Builder description(String var1);

        public Builder stepActionType(String var1);

        public Builder stepActionType(StepActionType var1);

        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration var1);

        default public Builder workflowStepAutomationConfiguration(Consumer<WorkflowStepAutomationConfiguration.Builder> workflowStepAutomationConfiguration) {
            return this.workflowStepAutomationConfiguration((WorkflowStepAutomationConfiguration)((WorkflowStepAutomationConfiguration.Builder)WorkflowStepAutomationConfiguration.builder().applyMutation(workflowStepAutomationConfiguration)).build());
        }

        public Builder stepTarget(Collection<String> var1);

        public Builder stepTarget(String ... var1);

        public Builder outputs(Collection<WorkflowStepOutput> var1);

        public Builder outputs(WorkflowStepOutput ... var1);

        public Builder outputs(Consumer<WorkflowStepOutput.Builder> ... var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);

        public Builder status(String var1);

        public Builder status(StepStatus var1);

        public Builder statusMessage(String var1);

        public Builder scriptOutputLocation(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastStartTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder noOfSrvCompleted(Integer var1);

        public Builder noOfSrvFailed(Integer var1);

        public Builder totalNoOfSrv(Integer var1);
    }
}

