/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<UpdateWorkflowResponse.Builder, UpdateWorkflowResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateWorkflowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWorkflowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(UpdateWorkflowResponse::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("adsApplicationConfigurationId")
            .getter(getter(UpdateWorkflowResponse::adsApplicationConfigurationId))
            .setter(setter(Builder::adsApplicationConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationConfigurationId")
                    .build()).build();

    private static final SdkField<Map<String, StepInput>> WORKFLOW_INPUTS_FIELD = SdkField
            .<Map<String, StepInput>> builder(MarshallingType.MAP)
            .memberName("workflowInputs")
            .getter(getter(UpdateWorkflowResponse::workflowInputs))
            .setter(setter(Builder::workflowInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowInputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<StepInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stepTargets")
            .getter(getter(UpdateWorkflowResponse::stepTargets))
            .setter(setter(Builder::stepTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(UpdateWorkflowResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime").getter(getter(UpdateWorkflowResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateWorkflowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_ID_FIELD, WORKFLOW_INPUTS_FIELD,
            STEP_TARGETS_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String templateId;

    private final String adsApplicationConfigurationId;

    private final Map<String, StepInput> workflowInputs;

    private final List<String> stepTargets;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> tags;

    private UpdateWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationId = builder.adsApplicationConfigurationId;
        this.workflowInputs = builder.workflowInputs;
        this.stepTargets = builder.stepTargets;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the migration workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the migration workflow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the migration workflow.
     * </p>
     * 
     * @return The name of the migration workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the migration workflow.
     * </p>
     * 
     * @return The description of the migration workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The ID of the application configured in Application Discovery Service.
     * </p>
     * 
     * @return The ID of the application configured in Application Discovery Service.
     */
    public final String adsApplicationConfigurationId() {
        return adsApplicationConfigurationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowInputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowInputs() {
        return workflowInputs != null && !(workflowInputs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The inputs required to update a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowInputs} method.
     * </p>
     * 
     * @return The inputs required to update a migration workflow.
     */
    public final Map<String, StepInput> workflowInputs() {
        return workflowInputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStepTargets() {
        return stepTargets != null && !(stepTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The servers on which a step will be run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepTargets} method.
     * </p>
     * 
     * @return The servers on which a step will be run.
     */
    public final List<String> stepTargets() {
        return stepTargets;
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the migration workflow was created.
     * </p>
     * 
     * @return The time at which the migration workflow was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the migration workflow was last modified.
     * </p>
     * 
     * @return The time at which the migration workflow was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags added to the migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags added to the migration workflow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(adsApplicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowInputs() ? workflowInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStepTargets() ? stepTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowResponse)) {
            return false;
        }
        UpdateWorkflowResponse other = (UpdateWorkflowResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(adsApplicationConfigurationId(), other.adsApplicationConfigurationId())
                && hasWorkflowInputs() == other.hasWorkflowInputs() && Objects.equals(workflowInputs(), other.workflowInputs())
                && hasStepTargets() == other.hasStepTargets() && Objects.equals(stepTargets(), other.stepTargets())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("TemplateId", templateId())
                .add("AdsApplicationConfigurationId", adsApplicationConfigurationId())
                .add("WorkflowInputs", workflowInputs() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StepTargets", hasStepTargets() ? stepTargets() : null).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "adsApplicationConfigurationId":
            return Optional.ofNullable(clazz.cast(adsApplicationConfigurationId()));
        case "workflowInputs":
            return Optional.ofNullable(clazz.cast(workflowInputs()));
        case "stepTargets":
            return Optional.ofNullable(clazz.cast(stepTargets()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("adsApplicationConfigurationId", ADS_APPLICATION_CONFIGURATION_ID_FIELD);
        map.put("workflowInputs", WORKFLOW_INPUTS_FIELD);
        map.put("stepTargets", STEP_TARGETS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowResponse, T> g) {
        return obj -> g.apply((UpdateWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkflowResponse> {
        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param id
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the migration workflow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the migration workflow.
         * </p>
         * 
         * @param name
         *        The name of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the migration workflow.
         * </p>
         * 
         * @param description
         *        The description of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The ID of the application configured in Application Discovery Service.
         * </p>
         * 
         * @param adsApplicationConfigurationId
         *        The ID of the application configured in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adsApplicationConfigurationId(String adsApplicationConfigurationId);

        /**
         * <p>
         * The inputs required to update a migration workflow.
         * </p>
         * 
         * @param workflowInputs
         *        The inputs required to update a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowInputs(Map<String, StepInput> workflowInputs);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(Collection<String> stepTargets);

        /**
         * <p>
         * The servers on which a step will be run.
         * </p>
         * 
         * @param stepTargets
         *        The servers on which a step will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepTargets(String... stepTargets);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(MigrationWorkflowStatusEnum status);

        /**
         * <p>
         * The time at which the migration workflow was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the migration workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the migration workflow was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the migration workflow was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The tags added to the migration workflow.
         * </p>
         * 
         * @param tags
         *        The tags added to the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private String templateId;

        private String adsApplicationConfigurationId;

        private Map<String, StepInput> workflowInputs = DefaultSdkAutoConstructMap.getInstance();

        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            templateId(model.templateId);
            adsApplicationConfigurationId(model.adsApplicationConfigurationId);
            workflowInputs(model.workflowInputs);
            stepTargets(model.stepTargets);
            status(model.status);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationId() {
            return adsApplicationConfigurationId;
        }

        public final void setAdsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
        }

        @Override
        public final Builder adsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
            return this;
        }

        public final Map<String, StepInput.Builder> getWorkflowInputs() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.workflowInputs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkflowInputs(Map<String, StepInput.BuilderImpl> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copyFromBuilder(workflowInputs);
        }

        @Override
        public final Builder workflowInputs(Map<String, StepInput> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copy(workflowInputs);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String... stepTargets) {
            stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateWorkflowResponse build() {
            return new UpdateWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
