/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input parameters of a template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateInput implements SdkPojo, Serializable, ToCopyableBuilder<TemplateInput.Builder, TemplateInput> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(TemplateInput::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(TemplateInput::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(TemplateInput::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            DATA_TYPE_FIELD, REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final String dataType;

    private final Boolean required;

    private TemplateInput(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.dataType = builder.dataType;
        this.required = builder.required;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * The data type of the template input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the template input.
     * @see DataType
     */
    public final DataType dataType() {
        return DataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the template input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the template input.
     * @see DataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * Determine if an input is required from the template.
     * </p>
     * 
     * @return Determine if an input is required from the template.
     */
    public final Boolean required() {
        return required;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateInput)) {
            return false;
        }
        TemplateInput other = (TemplateInput) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(required(), other.required());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateInput").add("InputName", inputName()).add("DataType", dataTypeAsString())
                .add("Required", required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputName", INPUT_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateInput, T> g) {
        return obj -> g.apply((TemplateInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateInput> {
        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param inputName
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * The data type of the template input.
         * </p>
         * 
         * @param dataType
         *        The data type of the template input.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the template input.
         * </p>
         * 
         * @param dataType
         *        The data type of the template input.
         * @see DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataType
         */
        Builder dataType(DataType dataType);

        /**
         * <p>
         * Determine if an input is required from the template.
         * </p>
         * 
         * @param required
         *        Determine if an input is required from the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private String dataType;

        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateInput model) {
            inputName(model.inputName);
            dataType(model.dataType);
            required(model.required);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public TemplateInput build() {
            return new TemplateInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
