/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplatesResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<ListTemplatesResponse.Builder, ListTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TemplateSummary>> TEMPLATE_SUMMARY_FIELD = SdkField
            .<List<TemplateSummary>> builder(MarshallingType.LIST)
            .memberName("templateSummary")
            .getter(getter(ListTemplatesResponse::templateSummary))
            .setter(setter(Builder::templateSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEMPLATE_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<TemplateSummary> templateSummary;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateSummary = builder.templateSummary;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateSummary property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateSummary() {
        return templateSummary != null && !(templateSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary of the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateSummary} method.
     * </p>
     * 
     * @return The summary of the template.
     */
    public final List<TemplateSummary> templateSummary() {
        return templateSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateSummary() ? templateSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTemplateSummary() == other.hasTemplateSummary()
                && Objects.equals(templateSummary(), other.templateSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplatesResponse").add("NextToken", nextToken())
                .add("TemplateSummary", hasTemplateSummary() ? templateSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "templateSummary":
            return Optional.ofNullable(clazz.cast(templateSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("templateSummary", TEMPLATE_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplatesResponse, T> g) {
        return obj -> g.apply((ListTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTemplatesResponse> {
        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The summary of the template.
         * </p>
         * 
         * @param templateSummary
         *        The summary of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSummary(Collection<TemplateSummary> templateSummary);

        /**
         * <p>
         * The summary of the template.
         * </p>
         * 
         * @param templateSummary
         *        The summary of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSummary(TemplateSummary... templateSummary);

        /**
         * <p>
         * The summary of the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #templateSummary(List<TemplateSummary>)}.
         * 
         * @param templateSummary
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateSummary(java.util.Collection<TemplateSummary>)
         */
        Builder templateSummary(Consumer<TemplateSummary.Builder>... templateSummary);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TemplateSummary> templateSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            templateSummary(model.templateSummary);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TemplateSummary.Builder> getTemplateSummary() {
            List<TemplateSummary.Builder> result = TemplateSummaryListCopier.copyToBuilder(this.templateSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateSummary(Collection<TemplateSummary.BuilderImpl> templateSummary) {
            this.templateSummary = TemplateSummaryListCopier.copyFromBuilder(templateSummary);
        }

        @Override
        public final Builder templateSummary(Collection<TemplateSummary> templateSummary) {
            this.templateSummary = TemplateSummaryListCopier.copy(templateSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummary(TemplateSummary... templateSummary) {
            templateSummary(Arrays.asList(templateSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummary(Consumer<TemplateSummary.Builder>... templateSummary) {
            templateSummary(Stream.of(templateSummary).map(c -> TemplateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
