/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends MigrationHubOrchestratorResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetWorkflowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetWorkflowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(GetWorkflowResponse::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> ADS_APPLICATION_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("adsApplicationConfigurationId")
            .getter(getter(GetWorkflowResponse::adsApplicationConfigurationId))
            .setter(setter(Builder::adsApplicationConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationConfigurationId")
                    .build()).build();

    private static final SdkField<String> ADS_APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adsApplicationName").getter(getter(GetWorkflowResponse::adsApplicationName))
            .setter(setter(Builder::adsApplicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsApplicationName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetWorkflowResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetWorkflowResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStartTime").getter(getter(GetWorkflowResponse::lastStartTime))
            .setter(setter(Builder::lastStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()).build();

    private static final SdkField<Instant> LAST_STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStopTime").getter(getter(GetWorkflowResponse::lastStopTime)).setter(setter(Builder::lastStopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStopTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime").getter(getter(GetWorkflowResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetWorkflowResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField
            .<List<Tool>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(GetWorkflowResponse::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalSteps").getter(getter(GetWorkflowResponse::totalSteps)).setter(setter(Builder::totalSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSteps").build()).build();

    private static final SdkField<Integer> COMPLETED_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("completedSteps").getter(getter(GetWorkflowResponse::completedSteps))
            .setter(setter(Builder::completedSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedSteps").build()).build();

    private static final SdkField<Map<String, StepInput>> WORKFLOW_INPUTS_FIELD = SdkField
            .<Map<String, StepInput>> builder(MarshallingType.MAP)
            .memberName("workflowInputs")
            .getter(getter(GetWorkflowResponse::workflowInputs))
            .setter(setter(Builder::workflowInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowInputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<StepInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetWorkflowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBucket").getter(getter(GetWorkflowResponse::workflowBucket))
            .setter(setter(Builder::workflowBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, ADS_APPLICATION_CONFIGURATION_ID_FIELD, ADS_APPLICATION_NAME_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_START_TIME_FIELD, LAST_STOP_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, TOOLS_FIELD, TOTAL_STEPS_FIELD, COMPLETED_STEPS_FIELD,
            WORKFLOW_INPUTS_FIELD, TAGS_FIELD, WORKFLOW_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String templateId;

    private final String adsApplicationConfigurationId;

    private final String adsApplicationName;

    private final String status;

    private final String statusMessage;

    private final Instant creationTime;

    private final Instant lastStartTime;

    private final Instant lastStopTime;

    private final Instant lastModifiedTime;

    private final Instant endTime;

    private final List<Tool> tools;

    private final Integer totalSteps;

    private final Integer completedSteps;

    private final Map<String, StepInput> workflowInputs;

    private final Map<String, String> tags;

    private final String workflowBucket;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.adsApplicationConfigurationId = builder.adsApplicationConfigurationId;
        this.adsApplicationName = builder.adsApplicationName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.lastStartTime = builder.lastStartTime;
        this.lastStopTime = builder.lastStopTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.tools = builder.tools;
        this.totalSteps = builder.totalSteps;
        this.completedSteps = builder.completedSteps;
        this.workflowInputs = builder.workflowInputs;
        this.tags = builder.tags;
        this.workflowBucket = builder.workflowBucket;
    }

    /**
     * <p>
     * The ID of the migration workflow.
     * </p>
     * 
     * @return The ID of the migration workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the migration workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the migration workflow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the migration workflow.
     * </p>
     * 
     * @return The name of the migration workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the migration workflow.
     * </p>
     * 
     * @return The description of the migration workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the template.
     * </p>
     * 
     * @return The ID of the template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The configuration ID of the application configured in Application Discovery Service.
     * </p>
     * 
     * @return The configuration ID of the application configured in Application Discovery Service.
     */
    public final String adsApplicationConfigurationId() {
        return adsApplicationConfigurationId;
    }

    /**
     * <p>
     * The name of the application configured in Application Discovery Service.
     * </p>
     * 
     * @return The name of the application configured in Application Discovery Service.
     */
    public final String adsApplicationName() {
        return adsApplicationName;
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final MigrationWorkflowStatusEnum status() {
        return MigrationWorkflowStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the migration workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MigrationWorkflowStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the migration workflow.
     * @see MigrationWorkflowStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the migration workflow.
     * </p>
     * 
     * @return The status message of the migration workflow.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time at which the migration workflow was created.
     * </p>
     * 
     * @return The time at which the migration workflow was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the migration workflow was last started.
     * </p>
     * 
     * @return The time at which the migration workflow was last started.
     */
    public final Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The time at which the migration workflow was last stopped.
     * </p>
     * 
     * @return The time at which the migration workflow was last stopped.
     */
    public final Instant lastStopTime() {
        return lastStopTime;
    }

    /**
     * <p>
     * The time at which the migration workflow was last modified.
     * </p>
     * 
     * @return The time at which the migration workflow was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time at which the migration workflow ended.
     * </p>
     * 
     * @return The time at which the migration workflow ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AWS services utilized in a migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTools} method.
     * </p>
     * 
     * @return List of AWS services utilized in a migration workflow.
     */
    public final List<Tool> tools() {
        return tools;
    }

    /**
     * <p>
     * The total number of steps in the migration workflow.
     * </p>
     * 
     * @return The total number of steps in the migration workflow.
     */
    public final Integer totalSteps() {
        return totalSteps;
    }

    /**
     * <p>
     * Get a list of completed steps in the migration workflow.
     * </p>
     * 
     * @return Get a list of completed steps in the migration workflow.
     */
    public final Integer completedSteps() {
        return completedSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowInputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowInputs() {
        return workflowInputs != null && !(workflowInputs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The inputs required for creating the migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowInputs} method.
     * </p>
     * 
     * @return The inputs required for creating the migration workflow.
     */
    public final Map<String, StepInput> workflowInputs() {
        return workflowInputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags added to the migration workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags added to the migration workflow.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the migration logs are stored.
     * </p>
     * 
     * @return The Amazon S3 bucket where the migration logs are stored.
     */
    public final String workflowBucket() {
        return workflowBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(adsApplicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(adsApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalSteps());
        hashCode = 31 * hashCode + Objects.hashCode(completedSteps());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowInputs() ? workflowInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(adsApplicationConfigurationId(), other.adsApplicationConfigurationId())
                && Objects.equals(adsApplicationName(), other.adsApplicationName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastStartTime(), other.lastStartTime()) && Objects.equals(lastStopTime(), other.lastStopTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(endTime(), other.endTime())
                && hasTools() == other.hasTools() && Objects.equals(tools(), other.tools())
                && Objects.equals(totalSteps(), other.totalSteps()) && Objects.equals(completedSteps(), other.completedSteps())
                && hasWorkflowInputs() == other.hasWorkflowInputs() && Objects.equals(workflowInputs(), other.workflowInputs())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(workflowBucket(), other.workflowBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("TemplateId", templateId())
                .add("AdsApplicationConfigurationId", adsApplicationConfigurationId())
                .add("AdsApplicationName", adsApplicationName()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTime", creationTime()).add("LastStartTime", lastStartTime())
                .add("LastStopTime", lastStopTime()).add("LastModifiedTime", lastModifiedTime()).add("EndTime", endTime())
                .add("Tools", hasTools() ? tools() : null).add("TotalSteps", totalSteps())
                .add("CompletedSteps", completedSteps())
                .add("WorkflowInputs", workflowInputs() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("WorkflowBucket", workflowBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "adsApplicationConfigurationId":
            return Optional.ofNullable(clazz.cast(adsApplicationConfigurationId()));
        case "adsApplicationName":
            return Optional.ofNullable(clazz.cast(adsApplicationName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastStartTime":
            return Optional.ofNullable(clazz.cast(lastStartTime()));
        case "lastStopTime":
            return Optional.ofNullable(clazz.cast(lastStopTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "totalSteps":
            return Optional.ofNullable(clazz.cast(totalSteps()));
        case "completedSteps":
            return Optional.ofNullable(clazz.cast(completedSteps()));
        case "workflowInputs":
            return Optional.ofNullable(clazz.cast(workflowInputs()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workflowBucket":
            return Optional.ofNullable(clazz.cast(workflowBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("adsApplicationConfigurationId", ADS_APPLICATION_CONFIGURATION_ID_FIELD);
        map.put("adsApplicationName", ADS_APPLICATION_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastStartTime", LAST_START_TIME_FIELD);
        map.put("lastStopTime", LAST_STOP_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("totalSteps", TOTAL_STEPS_FIELD);
        map.put("completedSteps", COMPLETED_STEPS_FIELD);
        map.put("workflowInputs", WORKFLOW_INPUTS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workflowBucket", WORKFLOW_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The ID of the migration workflow.
         * </p>
         * 
         * @param id
         *        The ID of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the migration workflow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the migration workflow.
         * </p>
         * 
         * @param name
         *        The name of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the migration workflow.
         * </p>
         * 
         * @param description
         *        The description of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the template.
         * </p>
         * 
         * @param templateId
         *        The ID of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The configuration ID of the application configured in Application Discovery Service.
         * </p>
         * 
         * @param adsApplicationConfigurationId
         *        The configuration ID of the application configured in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adsApplicationConfigurationId(String adsApplicationConfigurationId);

        /**
         * <p>
         * The name of the application configured in Application Discovery Service.
         * </p>
         * 
         * @param adsApplicationName
         *        The name of the application configured in Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adsApplicationName(String adsApplicationName);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the migration workflow.
         * </p>
         * 
         * @param status
         *        The status of the migration workflow.
         * @see MigrationWorkflowStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationWorkflowStatusEnum
         */
        Builder status(MigrationWorkflowStatusEnum status);

        /**
         * <p>
         * The status message of the migration workflow.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time at which the migration workflow was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the migration workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the migration workflow was last started.
         * </p>
         * 
         * @param lastStartTime
         *        The time at which the migration workflow was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The time at which the migration workflow was last stopped.
         * </p>
         * 
         * @param lastStopTime
         *        The time at which the migration workflow was last stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStopTime(Instant lastStopTime);

        /**
         * <p>
         * The time at which the migration workflow was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the migration workflow was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time at which the migration workflow ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the migration workflow ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * 
         * @param tools
         *        List of AWS services utilized in a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<Tool> tools);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * 
         * @param tools
         *        List of AWS services utilized in a migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Tool... tools);

        /**
         * <p>
         * List of AWS services utilized in a migration workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder#build()} is called
         * immediately and its result is passed to {@link #tools(List<Tool>)}.
         * 
         * @param tools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhuborchestrator.model.Tool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tools(java.util.Collection<Tool>)
         */
        Builder tools(Consumer<Tool.Builder>... tools);

        /**
         * <p>
         * The total number of steps in the migration workflow.
         * </p>
         * 
         * @param totalSteps
         *        The total number of steps in the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSteps(Integer totalSteps);

        /**
         * <p>
         * Get a list of completed steps in the migration workflow.
         * </p>
         * 
         * @param completedSteps
         *        Get a list of completed steps in the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedSteps(Integer completedSteps);

        /**
         * <p>
         * The inputs required for creating the migration workflow.
         * </p>
         * 
         * @param workflowInputs
         *        The inputs required for creating the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowInputs(Map<String, StepInput> workflowInputs);

        /**
         * <p>
         * The tags added to the migration workflow.
         * </p>
         * 
         * @param tags
         *        The tags added to the migration workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon S3 bucket where the migration logs are stored.
         * </p>
         * 
         * @param workflowBucket
         *        The Amazon S3 bucket where the migration logs are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBucket(String workflowBucket);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private String templateId;

        private String adsApplicationConfigurationId;

        private String adsApplicationName;

        private String status;

        private String statusMessage;

        private Instant creationTime;

        private Instant lastStartTime;

        private Instant lastStopTime;

        private Instant lastModifiedTime;

        private Instant endTime;

        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();

        private Integer totalSteps;

        private Integer completedSteps;

        private Map<String, StepInput> workflowInputs = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workflowBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            templateId(model.templateId);
            adsApplicationConfigurationId(model.adsApplicationConfigurationId);
            adsApplicationName(model.adsApplicationName);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            lastStartTime(model.lastStartTime);
            lastStopTime(model.lastStopTime);
            lastModifiedTime(model.lastModifiedTime);
            endTime(model.endTime);
            tools(model.tools);
            totalSteps(model.totalSteps);
            completedSteps(model.completedSteps);
            workflowInputs(model.workflowInputs);
            tags(model.tags);
            workflowBucket(model.workflowBucket);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getAdsApplicationConfigurationId() {
            return adsApplicationConfigurationId;
        }

        public final void setAdsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
        }

        @Override
        public final Builder adsApplicationConfigurationId(String adsApplicationConfigurationId) {
            this.adsApplicationConfigurationId = adsApplicationConfigurationId;
            return this;
        }

        public final String getAdsApplicationName() {
            return adsApplicationName;
        }

        public final void setAdsApplicationName(String adsApplicationName) {
            this.adsApplicationName = adsApplicationName;
        }

        @Override
        public final Builder adsApplicationName(String adsApplicationName) {
            this.adsApplicationName = adsApplicationName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MigrationWorkflowStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final Instant getLastStopTime() {
            return lastStopTime;
        }

        public final void setLastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
        }

        @Override
        public final Builder lastStopTime(Instant lastStopTime) {
            this.lastStopTime = lastStopTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder>... tools) {
            tools(Stream.of(tools).map(c -> Tool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalSteps() {
            return totalSteps;
        }

        public final void setTotalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
        }

        @Override
        public final Builder totalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public final Integer getCompletedSteps() {
            return completedSteps;
        }

        public final void setCompletedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
        }

        @Override
        public final Builder completedSteps(Integer completedSteps) {
            this.completedSteps = completedSteps;
            return this;
        }

        public final Map<String, StepInput.Builder> getWorkflowInputs() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.workflowInputs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkflowInputs(Map<String, StepInput.BuilderImpl> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copyFromBuilder(workflowInputs);
        }

        @Override
        public final Builder workflowInputs(Map<String, StepInput> workflowInputs) {
            this.workflowInputs = StepInputParametersCopier.copy(workflowInputs);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = StringMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowBucket() {
            return workflowBucket;
        }

        public final void setWorkflowBucket(String workflowBucket) {
            this.workflowBucket = workflowBucket;
        }

        @Override
        public final Builder workflowBucket(String workflowBucket) {
            this.workflowBucket = workflowBucket;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
