/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateRequest extends MigrationHubOrchestratorRequest implements
        ToCopyableBuilder<CreateTemplateRequest.Builder, CreateTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateName").getter(getter(CreateTemplateRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateDescription").getter(getter(CreateTemplateRequest::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateDescription").build())
            .build();

    private static final SdkField<TemplateSource> TEMPLATE_SOURCE_FIELD = SdkField
            .<TemplateSource> builder(MarshallingType.SDK_POJO).memberName("templateSource")
            .getter(getter(CreateTemplateRequest::templateSource)).setter(setter(Builder::templateSource))
            .constructor(TemplateSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSource").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_SOURCE_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateName;

    private final String templateDescription;

    private final TemplateSource templateSource;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateDescription = builder.templateDescription;
        this.templateSource = builder.templateSource;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the migration workflow template.
     * </p>
     * 
     * @return The name of the migration workflow template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * A description of the migration workflow template.
     * </p>
     * 
     * @return A description of the migration workflow template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The source of the migration workflow template.
     * </p>
     * 
     * @return The source of the migration workflow template.
     */
    public final TemplateSource templateSource() {
        return templateSource;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait">Idempotency</a>
     * in the Smithy documentation.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait">Idempotency</a> in the
     *         Smithy documentation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the migration workflow template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the migration workflow template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateSource());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateSource(), other.templateSource()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTemplateRequest").add("TemplateName", templateName())
                .add("TemplateDescription", templateDescription()).add("TemplateSource", templateSource())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "templateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "templateSource":
            return Optional.ofNullable(clazz.cast(templateSource()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("templateDescription", TEMPLATE_DESCRIPTION_FIELD);
        map.put("templateSource", TEMPLATE_SOURCE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateRequest, T> g) {
        return obj -> g.apply((CreateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubOrchestratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTemplateRequest> {
        /**
         * <p>
         * The name of the migration workflow template.
         * </p>
         * 
         * @param templateName
         *        The name of the migration workflow template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * A description of the migration workflow template.
         * </p>
         * 
         * @param templateDescription
         *        A description of the migration workflow template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The source of the migration workflow template.
         * </p>
         * 
         * @param templateSource
         *        The source of the migration workflow template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSource(TemplateSource templateSource);

        /**
         * <p>
         * The source of the migration workflow template.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateSource.Builder} avoiding the need
         * to create one manually via {@link TemplateSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateSource.Builder#build()} is called immediately and its
         * result is passed to {@link #templateSource(TemplateSource)}.
         * 
         * @param templateSource
         *        a consumer that will call methods on {@link TemplateSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateSource(TemplateSource)
         */
        default Builder templateSource(Consumer<TemplateSource.Builder> templateSource) {
            return templateSource(TemplateSource.builder().applyMutation(templateSource).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait">Idempotency</a> in the Smithy
         * documentation.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://smithy.io/2.0/spec/behavior-traits.html#idempotencytoken-trait">Idempotency</a> in the
         *        Smithy documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to add to the migration workflow template.
         * </p>
         * 
         * @param tags
         *        The tags to add to the migration workflow template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubOrchestratorRequest.BuilderImpl implements Builder {
        private String templateName;

        private String templateDescription;

        private TemplateSource templateSource;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            templateDescription(model.templateDescription);
            templateSource(model.templateSource);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final TemplateSource.Builder getTemplateSource() {
            return templateSource != null ? templateSource.toBuilder() : null;
        }

        public final void setTemplateSource(TemplateSource.BuilderImpl templateSource) {
            this.templateSource = templateSource != null ? templateSource.build() : null;
        }

        @Override
        public final Builder templateSource(TemplateSource templateSource) {
            this.templateSource = templateSource;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
