/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary;
import software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplatesResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, ListTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTemplatesResponse.getter(ListTemplatesResponse::nextToken)).setter(ListTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TemplateSummary>> TEMPLATE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateSummary").getter(ListTemplatesResponse.getter(ListTemplatesResponse::templateSummary)).setter(ListTemplatesResponse.setter(Builder::templateSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATE_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TemplateSummary> templateSummary;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateSummary = builder.templateSummary;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplateSummary() {
        return this.templateSummary != null && !(this.templateSummary instanceof SdkAutoConstructList);
    }

    public final List<TemplateSummary> templateSummary() {
        return this.templateSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateSummary() ? this.templateSummary() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplateSummary() == other.hasTemplateSummary() && Objects.equals(this.templateSummary(), other.templateSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ListTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("TemplateSummary", this.hasTemplateSummary() ? this.templateSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templateSummary": {
                return Optional.ofNullable(clazz.cast(this.templateSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("templateSummary", TEMPLATE_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplatesResponse, T> g) {
        return obj -> g.apply((ListTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TemplateSummary> templateSummary = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templateSummary(model.templateSummary);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TemplateSummary.Builder> getTemplateSummary() {
            List<TemplateSummary.Builder> result = TemplateSummaryListCopier.copyToBuilder(this.templateSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateSummary(Collection<TemplateSummary.BuilderImpl> templateSummary) {
            this.templateSummary = TemplateSummaryListCopier.copyFromBuilder(templateSummary);
        }

        @Override
        public final Builder templateSummary(Collection<TemplateSummary> templateSummary) {
            this.templateSummary = TemplateSummaryListCopier.copy(templateSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummary(TemplateSummary ... templateSummary) {
            this.templateSummary(Arrays.asList(templateSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummary(Consumer<TemplateSummary.Builder> ... templateSummary) {
            this.templateSummary(Stream.of(templateSummary).map(c -> (TemplateSummary)((TemplateSummary.Builder)TemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder templateSummary(Collection<TemplateSummary> var1);

        public Builder templateSummary(TemplateSummary ... var1);

        public Builder templateSummary(Consumer<TemplateSummary.Builder> ... var1);
    }
}

