/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Owner;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepGroupStatus;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.Tool;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ToolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowStepGroupResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetWorkflowStepGroupResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::id)).setter(GetWorkflowStepGroupResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::workflowId)).setter(GetWorkflowStepGroupResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::name)).setter(GetWorkflowStepGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::description)).setter(GetWorkflowStepGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::statusAsString)).setter(GetWorkflowStepGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::ownerAsString)).setter(GetWorkflowStepGroupResponse.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::creationTime)).setter(GetWorkflowStepGroupResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::lastModifiedTime)).setter(GetWorkflowStepGroupResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::endTime)).setter(GetWorkflowStepGroupResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tools").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::tools)).setter(GetWorkflowStepGroupResponse.setter(Builder::tools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::previous)).setter(GetWorkflowStepGroupResponse.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(GetWorkflowStepGroupResponse.getter(GetWorkflowStepGroupResponse::next)).setter(GetWorkflowStepGroupResponse.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, WORKFLOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, OWNER_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, TOOLS_FIELD, PREVIOUS_FIELD, NEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowStepGroupResponse.memberNameToFieldInitializer();
    private final String id;
    private final String workflowId;
    private final String name;
    private final String description;
    private final String status;
    private final String owner;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Instant endTime;
    private final List<Tool> tools;
    private final List<String> previous;
    private final List<String> next;

    private GetWorkflowStepGroupResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.workflowId = builder.workflowId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.owner = builder.owner;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.tools = builder.tools;
        this.previous = builder.previous;
        this.next = builder.next;
    }

    public final String id() {
        return this.id;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final StepGroupStatus status() {
        return StepGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Owner owner() {
        return Owner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasTools() {
        return this.tools != null && !(this.tools instanceof SdkAutoConstructList);
    }

    public final List<Tool> tools() {
        return this.tools;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTools() ? this.tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepGroupResponse)) {
            return false;
        }
        GetWorkflowStepGroupResponse other = (GetWorkflowStepGroupResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.ownerAsString(), other.ownerAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasTools() == other.hasTools() && Objects.equals(this.tools(), other.tools()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowStepGroupResponse").add("Id", (Object)this.id()).add("WorkflowId", (Object)this.workflowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Owner", (Object)this.ownerAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EndTime", (Object)this.endTime()).add("Tools", this.hasTools() ? this.tools() : null).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "tools": {
                return Optional.ofNullable(clazz.cast(this.tools()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("tools", TOOLS_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowStepGroupResponse, T> g) {
        return obj -> g.apply((GetWorkflowStepGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String workflowId;
        private String name;
        private String description;
        private String status;
        private String owner;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private Instant endTime;
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowStepGroupResponse model) {
            super(model);
            this.id(model.id);
            this.workflowId(model.workflowId);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.owner(model.owner);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.endTime(model.endTime);
            this.tools(model.tools);
            this.previous(model.previous);
            this.next(model.next);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool ... tools) {
            this.tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder> ... tools) {
            this.tools(Stream.of(tools).map(c -> (Tool)((Tool.Builder)Tool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        @Override
        public GetWorkflowStepGroupResponse build() {
            return new GetWorkflowStepGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowStepGroupResponse> {
        public Builder id(String var1);

        public Builder workflowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(StepGroupStatus var1);

        public Builder owner(String var1);

        public Builder owner(Owner var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder tools(Collection<Tool> var1);

        public Builder tools(Tool ... var1);

        public Builder tools(Consumer<Tool.Builder> ... var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);
    }
}

