/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepInputParametersCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkflowRequest
extends MigrationHubOrchestratorRequest
implements ToCopyableBuilder<Builder, UpdateWorkflowRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::id)).setter(UpdateWorkflowRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::name)).setter(UpdateWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::description)).setter(UpdateWorkflowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, StepInput>> INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("inputParameters").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::inputParameters)).setter(UpdateWorkflowRequest.setter(Builder::inputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STEP_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepTargets").getter(UpdateWorkflowRequest.getter(UpdateWorkflowRequest::stepTargets)).setter(UpdateWorkflowRequest.setter(Builder::stepTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, INPUT_PARAMETERS_FIELD, STEP_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkflowRequest.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String description;
    private final Map<String, StepInput> inputParameters;
    private final List<String> stepTargets;

    private UpdateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.inputParameters = builder.inputParameters;
        this.stepTargets = builder.stepTargets;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInputParameters() {
        return this.inputParameters != null && !(this.inputParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, StepInput> inputParameters() {
        return this.inputParameters;
    }

    public final boolean hasStepTargets() {
        return this.stepTargets != null && !(this.stepTargets instanceof SdkAutoConstructList);
    }

    public final List<String> stepTargets() {
        return this.stepTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputParameters() ? this.inputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepTargets() ? this.stepTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasInputParameters() == other.hasInputParameters() && Objects.equals(this.inputParameters(), other.inputParameters()) && this.hasStepTargets() == other.hasStepTargets() && Objects.equals(this.stepTargets(), other.stepTargets());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkflowRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InputParameters", (Object)(this.inputParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("StepTargets", this.hasStepTargets() ? this.stepTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputParameters": {
                return Optional.ofNullable(clazz.cast(this.inputParameters()));
            }
            case "stepTargets": {
                return Optional.ofNullable(clazz.cast(this.stepTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputParameters", INPUT_PARAMETERS_FIELD);
        map.put("stepTargets", STEP_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Map<String, StepInput> inputParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> stepTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.inputParameters(model.inputParameters);
            this.stepTargets(model.stepTargets);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, StepInput.Builder> getInputParameters() {
            Map<String, StepInput.Builder> result = StepInputParametersCopier.copyToBuilder(this.inputParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputParameters(Map<String, StepInput.BuilderImpl> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copyFromBuilder(inputParameters);
        }

        @Override
        public final Builder inputParameters(Map<String, StepInput> inputParameters) {
            this.inputParameters = StepInputParametersCopier.copy(inputParameters);
            return this;
        }

        public final Collection<String> getStepTargets() {
            if (this.stepTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepTargets;
        }

        public final void setStepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
        }

        @Override
        public final Builder stepTargets(Collection<String> stepTargets) {
            this.stepTargets = StringListCopier.copy(stepTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTargets(String ... stepTargets) {
            this.stepTargets(Arrays.asList(stepTargets));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowRequest build() {
            return new UpdateWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkflowRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder inputParameters(Map<String, StepInput> var1);

        public Builder stepTargets(Collection<String> var1);

        public Builder stepTargets(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

