/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StepStatus {
    AWAITING_DEPENDENCIES("AWAITING_DEPENDENCIES"),
    SKIPPED("SKIPPED"),
    READY("READY"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    PAUSED("PAUSED"),
    USER_ATTENTION_REQUIRED("USER_ATTENTION_REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StepStatus> VALUE_MAP;
    private final String value;

    private StepStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StepStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StepStatus> knownValues() {
        EnumSet<StepStatus> knownValues = EnumSet.allOf(StepStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StepStatus.class, StepStatus::toString);
    }
}

