/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginSummary> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(PluginSummary.getter(PluginSummary::pluginId)).setter(PluginSummary.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(PluginSummary.getter(PluginSummary::hostname)).setter(PluginSummary.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PluginSummary.getter(PluginSummary::statusAsString)).setter(PluginSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(PluginSummary.getter(PluginSummary::ipAddress)).setter(PluginSummary.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PluginSummary.getter(PluginSummary::version)).setter(PluginSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> REGISTERED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registeredTime").getter(PluginSummary.getter(PluginSummary::registeredTime)).setter(PluginSummary.setter(Builder::registeredTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD, HOSTNAME_FIELD, STATUS_FIELD, IP_ADDRESS_FIELD, VERSION_FIELD, REGISTERED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PluginSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pluginId;
    private final String hostname;
    private final String status;
    private final String ipAddress;
    private final String version;
    private final String registeredTime;

    private PluginSummary(BuilderImpl builder) {
        this.pluginId = builder.pluginId;
        this.hostname = builder.hostname;
        this.status = builder.status;
        this.ipAddress = builder.ipAddress;
        this.version = builder.version;
        this.registeredTime = builder.registeredTime;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final PluginHealth status() {
        return PluginHealth.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String version() {
        return this.version;
    }

    public final String registeredTime() {
        return this.registeredTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginSummary)) {
            return false;
        }
        PluginSummary other = (PluginSummary)obj;
        return Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.registeredTime(), other.registeredTime());
    }

    public final String toString() {
        return ToString.builder((String)"PluginSummary").add("PluginId", (Object)this.pluginId()).add("Hostname", (Object)this.hostname()).add("Status", (Object)this.statusAsString()).add("IpAddress", (Object)this.ipAddress()).add("Version", (Object)this.version()).add("RegisteredTime", (Object)this.registeredTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "registeredTime": {
                return Optional.ofNullable(clazz.cast(this.registeredTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("registeredTime", REGISTERED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginSummary, T> g) {
        return obj -> g.apply((PluginSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pluginId;
        private String hostname;
        private String status;
        private String ipAddress;
        private String version;
        private String registeredTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginSummary model) {
            this.pluginId(model.pluginId);
            this.hostname(model.hostname);
            this.status(model.status);
            this.ipAddress(model.ipAddress);
            this.version(model.version);
            this.registeredTime(model.registeredTime);
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PluginHealth status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRegisteredTime() {
            return this.registeredTime;
        }

        public final void setRegisteredTime(String registeredTime) {
            this.registeredTime = registeredTime;
        }

        @Override
        public final Builder registeredTime(String registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        public PluginSummary build() {
            return new PluginSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginSummary> {
        public Builder pluginId(String var1);

        public Builder hostname(String var1);

        public Builder status(String var1);

        public Builder status(PluginHealth var1);

        public Builder ipAddress(String var1);

        public Builder version(String var1);

        public Builder registeredTime(String var1);
    }
}

